<x-dashboard.layout :title="__('dashboard.edit') . ' ' . $product->name">

    @section('style')
    <style>
    img {
        display: block !important;
    }

    .sortable-container {
        cursor: move;
    }

    .sortable-container.sortable-ghost {
        opacity: 0.5;
    }

    /* تحسين مظهر الـ drag handle */
    .drag-handle {
        position: absolute;
        top: 10px;
        right: 10px;
        background: rgba(0, 0, 0, 0.7);
        color: white;
        padding: 5px 8px;
        border-radius: 4px;
        cursor: move;
        font-size: 14px;
        z-index: 10;
        user-select: none;
        transition: all 0.3s ease;
    }

    .drag-handle:hover {
        background: rgba(0, 0, 0, 0.9);
        transform: scale(1.1);
    }

    .sortable-container:hover .drag-handle {
        opacity: 1;
    }

    .drag-handle:active {
        transform: scale(0.95);
    }

    /* تحسين مظهر التعليمات */
    .alert-info {
        border-left: 4px solid #17a2b8;
        background: linear-gradient(135deg, #d1ecf1 0%, #bee5eb 100%);
    }

    .sortable-container.sortable-chosen {
        background-color: #f8f9fa;
        border: 2px dashed #007bff;
    }

    .drag-handle {
        cursor: move;
        position: absolute;
        top: 5px;
        right: 5px;
        background: rgba(0, 0, 0, 0.5);
        color: white;
        padding: 2px 6px;
        border-radius: 3px;
        font-size: 12px;
        z-index: 10;
    }

    .sortable-drag {
        opacity: 0.5;
        transform: rotate(5deg);
    }

    .sortable-ghost {
        opacity: 0.3;
        background: #f8f9fa;
        border: 2px dashed #007bff;
    }

    .sortable-chosen {
        background-color: #e3f2fd;
        border: 2px solid #2196f3;
    }

    .sortable-container:hover {
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
    }
    </style>
    @endsection

    <!-- Page Header -->
    <x-dashboard.partials.page-header :header="__('dashboard.edit') . ' ' . $product->name"
        :label_url="route('dashboard.products.index')" :label="__('dashboard.products')" />
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between">
                    <h4 class="card-title pt-3">{{ __('dashboard.edit') . ' ' . $product->name }}</h4>
                </div>

                <div class="card-body">
                    <form action="{{ route('dashboard.products.update', [$product->id]) }}" method="POST"
                        enctype="multipart/form-data">
                        @csrf
                        @method('PATCH')
                        <div class="row">

                            <x-dashboard.multilingual-input name="name" type="text" :required="true"
                                :model="$product" />

                            <div class="form-group col-md-2">
                                <label>{{ __('dashboard.order') }}</label>
                                <input class="form-control" name="order" type="number"
                                    value="{{ old('order', $product->order) }}"
                                    placeholder="{{ __('dashboard.order') }}">
                                @error('order')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="parent">{{ __('dashboard.parent') }}</label>
                                <select class="form-control select2" name="parent_id">
                                    <option value="">{{ __('dashboard.no_parent') }}</option>
                                    @foreach ($products as $productItem)
                                    <option value="{{ $productItem->id }}"
                                        {{ old('parent_id', $product->parent_id) == $productItem->id ? 'selected' : '' }}>
                                        {{ $productItem->name }}
                                    </option>
                                    @endforeach
                                </select>
                                @error('parent_id')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-3">
                                <label for="category_id">{{ __('dashboard.category') }}</label>
                                <select class="form-control select2" name="category_id">
                                    <option value="">{{ __('dashboard.select_category') }}</option>
                                    @if(isset($categories))
                                    @foreach ($categories as $category)
                                    <option value="{{ $category->id }}"
                                        {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>
                                        {{ $category->name }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                                @error('category_id')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-3">
                                <label for="service_id">{{ __('dashboard.service') }}</label>
                                <select class="form-control select2" name="service_id">
                                    <option value="">{{ __('dashboard.select_service') }}</option>
                                    @if(isset($services))
                                    @foreach ($services as $service)
                                    <option value="{{ $service->id }}"
                                        {{ old('service_id', $product->service_id) == $service->id ? 'selected' : '' }}>
                                        {{ $service->name }}
                                    </option>
                                    @endforeach
                                    @endif
                                </select>
                                @error('service_id')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.image') }} (225px * 225px max 1mb)</label>
                                <input type="file" class="form-control" name="image" accept="image/*">
                                @error('image')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="">{{ __('dashboard.current_image') }}</label>
                                @if ($product->image_path)
                                <img src="{{ $product->image_path }}" width="150" class="img-thumbnail">
                                @else
                                <p class="text-muted">{{ __('dashboard.no_image') }}</p>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_image') }}</label>
                                <input class="form-control" name="alt_image" type="text"
                                    placeholder="{{ __('dashboard.alt_image') }}"
                                    value="{{ old('alt_image', $product->alt_image) }}">
                            </div>

                            <div class="form-group col-md-6">
                                <label>{{ __('dashboard.icon') }} (50px * 50px max 1mb)</label>
                                <input type="file" class="form-control" name="icon" accept="image/*">
                                @error('icon')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-md-2">
                                <label for="">{{ __('dashboard.current_icon') }}</label>
                                @if ($product->icon_path)
                                <img src="{{ $product->icon_path }}" width="150" class="img-thumbnail">
                                @else
                                <p class="text-muted">{{ __('dashboard.no_icon') }}</p>
                                @endif
                            </div>

                            <div class="form-group col-md-4">
                                <label class="">{{ __('dashboard.alt_icon') }}</label>
                                <input class="form-control" name="alt_icon" type="text"
                                    placeholder="{{ __('dashboard.alt_icon') }}"
                                    value="{{ old('alt_icon', $product->alt_icon) }}">
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <!-- Multilingual Short Description -->
                            <x-dashboard.multilingual-input name="short_desc" type="textarea" :required="true" rows="4"
                                :model="$product" />
                            <!-- Multilingual Long Description -->
                            <x-dashboard.multilingual-input name="long_desc" type="editor" rows="10"
                                :model="$product" />

                            <!-- Multilingual Clients -->
                            <x-dashboard.multilingual-input name="clients" type="text" :required="false"
                                :model="$product" />

                            <!-- Multilingual Location -->
                            <x-dashboard.multilingual-input name="location" type="text" :required="false"
                                :model="$product" />

                            <div class="form-group col-md-3">
                                <label for="date">{{ __('dashboard.date') }}</label>
                                <input type="date" class="form-control @error('date') is-invalid @enderror" id="date"
                                    name="date" value="{{ old('date', $product->date) }}">
                                @error('date')
                                <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="form-group col-md-12">
                                <label for="product_images">{{ trans('dashboard.product_images') }}</label>

                                <!-- Dropzone Upload Area -->
                                <div class="upload_images dropzone" id="product-dropzone">
                                    <div class="dz-message">
                                        <i class="fas fa-cloud-upload-alt fa-3x text-muted mb-3"></i>
                                        <h5>{{ __('dashboard.drag_drop_files_here') }}</h5>
                                        <p class="text-muted">{{ __('dashboard.or_click_to_select_files') }}</p>
                                        <small class="text-muted">{{ __('dashboard.max_file_size_5mb') }}</small>
                                    </div>
                                </div>

                                <!-- Fallback for older browsers -->
                                <div class="mt-3">
                                    <input type="file" class="form-control" name="product_images[]" multiple
                                        accept="image/*" style="display: none;" id="fallback-upload">
                                    <button type="button" class="btn btn-outline-secondary"
                                        onclick="document.getElementById('fallback-upload').click()">
                                        <i class="fas fa-upload me-2"></i>{{ __('dashboard.select_files') }}
                                    </button>
                                </div>

                                @error('product_images')
                                <div class="text-danger">{{ $message }}</div>
                                @enderror
                            </div>

                            @if (!empty($product->images) && $product->images->count() > 0)
                            <div class="col-12">
                                <hr>
                                <h5>{{ __('dashboard.current_images') }}</h5>

                                <div class="d-flex flex-wrap mb-3 align-items-center">
                                    <button type="button" id="select_all_images" class="btn btn-secondary me-2 mb-2">
                                        {{ trans('dashboard.select_all') }}
                                    </button>
                                    <button type="button" id="unselect_all_images" class="btn btn-secondary me-2 mb-2">
                                        {{ trans('dashboard.unselect_all') }}
                                    </button>
                                    <button type="button" id="delete_selected_images" class="btn btn-danger me-2 mb-2">
                                        {{ trans('dashboard.delete_selected') }}
                                    </button>
                                    <button type="button" id="delete_all_images" class="btn btn-danger me-2 mb-2">
                                        {{ trans('dashboard.delete_all') }}
                                    </button>
                                    <button type="button" id="save_order_btn" class="btn btn-success me-2 mb-2">
                                        {{ trans('dashboard.save_order') }}
                                    </button>
                                </div>

                                <!-- تعليمات للمستخدم -->
                                <div class="alert alert-info mb-3">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>{{ __('dashboard.drag_drop_instructions') }}:</strong>
                                    {{ __('dashboard.drag_drop_description') }}
                                </div>

                                <div class="row" id="sortable-images">
                                    @foreach ($product->images as $key => $image)
                                    <div class="col-md-3 col-sm-6 mb-3 sortable-container" data-id="{{ $image->id }}">
                                        <div class="card">
                                            <div class="position-relative">
                                                <div class="drag-handle">⋮⋮</div>
                                                <img class="card-img-top" src="{{ $image->image_url }}"
                                                    style="height: 200px; object-fit: cover;">
                                            </div>
                                            <div class="card-body text-center">
                                                <input type="checkbox" name="selected_images[]" value="{{ $image->id }}"
                                                    class="select_image_checkbox mb-2">
                                                <button type="button" data-image="{{ $image->id }}"
                                                    class="delete_img_btn btn btn-danger btn-sm">
                                                    {{ trans('dashboard.delete') }}
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </div>
                            </div>
                            @endif

                            <div class="col-12">
                                <hr>
                            </div>

                            <div class="row mt-3">
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.publish/unpublish') }}</h5>
                                        <input type="checkbox" id="switch1" switch="none" value="1" name="status"
                                            {{ old('status', $product->status) ? 'checked' : '' }} />
                                        <label for="switch1" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_home') }}</h5>
                                        <input type="checkbox" id="switch2" switch="none" value="1" name="show_in_home"
                                            {{ old('show_in_home', $product->show_in_home) ? 'checked' : '' }} />
                                        <label for="switch2" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_header') }}</h5>
                                        <input type="checkbox" id="switch3" switch="none" value="1"
                                            name="show_in_header"
                                            {{ old('show_in_header', $product->show_in_header) ? 'checked' : '' }} />
                                        <label for="switch3" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                                <div class="form-group col-md-3">
                                    <div class="d-flex flex-wrap gap-2">
                                        <h5 class="font-size-14 mb-3">{{ __('dashboard.show_in_footer') }}</h5>
                                        <input type="checkbox" id="switch4" switch="none" value="1"
                                            name="show_in_footer"
                                            {{ old('show_in_footer', $product->show_in_footer) ? 'checked' : '' }} />
                                        <label for="switch4" data-on-label="{{ __('dashboard.yes') }}"
                                            data-off-label="{{ __('dashboard.no') }}"></label>
                                    </div>
                                </div>
                            </div>

                            <div class="col-12">
                                <hr>
                                <h4 class="card-title">{{ __('dashboard.seo') }}</h4>

                                <div class="row">
                                    <x-dashboard.multilingual-input name="slug" type="text" :required="false"
                                        :model="$product" />
                                    <x-dashboard.multilingual-input name="meta_title" type="textarea" :required="false"
                                        :rows="2" :model="$product" />
                                    <x-dashboard.multilingual-input name="meta_desc" type="textarea" :required="false"
                                        :rows="2" :model="$product" />

                                    <div class="form-group col-md-12">
                                        <div class="d-flex flex-wrap gap-2">
                                            <h5 class="font-size-14 mb-3">{{ __('dashboard.meta_robots') }} (index)
                                            </h5>
                                            <input type="checkbox" id="switch5" switch="none" value="1" name="index"
                                                {{ old('index', $product->index) ? 'checked' : '' }} />
                                            <label for="switch5" data-on-label="{{ __('dashboard.yes') }}"
                                                data-off-label="{{ __('dashboard.no') }}"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>


                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success">
                                    <i class="icon-note"></i> {{ __('dashboard.update') }}
                                </button>
                                <a href="{{ route('dashboard.products.index') }}" class="btn btn-danger ms-2">
                                    <i class="icon-trash"></i> {{ __('dashboard.cancel') }}
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->

    @section('script')
    <!-- Rich Text Editor (TinyMCE 6 - Latest Version) -->
    <script src="https://cdn.jsdelivr.net/npm/sortablejs@1.15.0/Sortable.min.js"></script>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/min/dropzone.min.css" rel="stylesheet">
    <link href="{{ asset('assets/dashboard/css/dropzone-custom.css') }}" rel="stylesheet">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/dropzone/4.0.1/dropzone.js"></script>

    <script type="text/javascript">
    // إعداد البيانات الأساسية
    window.productId = "{{ $product->id ?? '' }}";
    window.routes = {
        uploadImages: "{{ route('dashboard.dashboard.products.uploadImages') }}",
        deleteSelectedImages: "{{ route('dashboard.dashboard.products.deleteSelectedImages') }}",
        deleteAllImages: "{{ route('dashboard.dashboard.products.deleteAllImages') }}",
        deleteImage: "{{ route('dashboard.dashboard.products.deleteImage') }}",
        reorderImages: "{{ route('dashboard.dashboard.products.reorderImages') }}",
        removeUploadImages: "{{ route('dashboard.dashboard.products.removeUploadImages') }}",
        updateImageOrder: "{{ route('dashboard.dashboard.products.updateImageOrder') }}",
    };

    // ترجمات للاستخدام في JavaScript
    window.translations = {
        select_all: "{{ __('dashboard.select_all') }}",
        unselect_all: "{{ __('dashboard.unselect_all') }}",
        please_select_images_to_delete: "{{ __('dashboard.please_select_images_to_delete') }}",
        confirm_delete_selected_images: "{{ __('dashboard.confirm_delete_selected_images') }}",
        confirm_delete_all_images: "{{ __('dashboard.confirm_delete_all_images') }}",
        confirm_delete_this_image: "{{ __('dashboard.confirm_delete_this_image') }}",
        order_changed: "{{ __('dashboard.order_changed') }}",
        no_images_to_save_order: "{{ __('dashboard.no_images_to_save_order') }}",
        order_saved_successfully: "{{ __('dashboard.order_saved_successfully') }}",
        error_saving_order: "{{ __('dashboard.error_saving_order') }}",
        error_occurred_during_deletion: "{{ __('dashboard.error_occurred_during_deletion') }}",
        max_image_size_1mb: "{{ __('dashboard.max_image_size_1mb') }}",
    };

    // إعداد CSRF token
    window.csrfToken = "{{ csrf_token() }}";

    // إعداد Dropzone للمنتجات
    Dropzone.autoDiscover = false;

    // انتظار تحميل الصفحة
    $(document).ready(function() {
        var productDropzone = new Dropzone("#product-dropzone", {
            url: window.routes.uploadImages,
            paramName: "file",
            maxFilesize: 5, // MB
            acceptedFiles: ".jpeg,.jpg,.png,.gif,.webp",
            addRemoveLinks: true,
            dictDefaultMessage: "{{ __('dashboard.drag_drop_files_here') }}",
            dictRemoveFile: "{{ __('dashboard.remove_file') }}",
            dictCancelUpload: "{{ __('dashboard.cancel_upload') }}",
            dictUploadCanceled: "{{ __('dashboard.upload_canceled') }}",
            dictInvalidFileType: "{{ __('dashboard.invalid_file_type') }}",
            dictFileTooBig: "{{ __('dashboard.file_too_big') }}",
            dictResponseError: "{{ __('dashboard.server_error') }}",
            init: function() {
                var dropzone = this;

                // إضافة productId عند الرفع
                this.on("sending", function(file, xhr, formData) {
                    formData.append("productId", window.productId);
                    formData.append("_token", window.csrfToken);
                });

                // عند نجاح الرفع
                this.on("success", function(file, response) {
                    if (response.success) {
                        console.log('Product image uploaded successfully:', response);
                        // إضافة معرف الصورة للعنصر
                        file.previewElement.setAttribute('data-image-id', response
                            .image_id);

                        // إضافة رقم الترتيب
                        var orderNumber = dropzone.files.length;
                        file.previewElement.innerHTML += '<div class="dz-order">' +
                            orderNumber + '</div>';

                        // تفعيل الترتيب التفاعلي
                        initializeSortable();
                    } else {
                        console.error('Upload failed:', response.message);
                        this.removeFile(file);
                    }
                });

                // عند فشل الرفع
                this.on("error", function(file, errorMessage) {
                    console.error('Upload error:', errorMessage);
                    alert('{{ __('
                        dashboard.upload_failed ') }}: ' + errorMessage);
                });

                // عند حذف الملف
                this.on("removedfile", function(file) {
                    var imageId = file.previewElement.getAttribute('data-image-id');
                    if (imageId) {
                        // حذف الصورة من الخادم
                        $.ajax({
                            url: window.routes.removeUploadImages,
                            type: 'POST',
                            data: {
                                name: file.name,
                                _token: window.csrfToken
                            },
                            success: function(response) {
                                console.log('Image removed from server:',
                                    response);
                            },
                            error: function(xhr, status, error) {
                                console.error(
                                    'Error removing image from server:',
                                    error);
                            }
                        });
                    }
                });
            }
        });

        // دالة تفعيل الترتيب التفاعلي
        function initializeSortable() {
            if (typeof Sortable !== 'undefined') {
                var dropzoneElement = document.getElementById('product-dropzone');
                if (dropzoneElement && !dropzoneElement.sortableInstance) {
                    dropzoneElement.sortableInstance = new Sortable(dropzoneElement, {
                        animation: 200,
                        ghostClass: 'dz-sortable-dragging',
                        chosenClass: 'dz-sortable-chosen',
                        dragClass: 'dz-sortable-drag',
                        onEnd: function(evt) {
                            // تحديث أرقام الترتيب
                            updateOrderNumbers();

                            // حفظ الترتيب الجديد في الخادم
                            saveImageOrder();
                        }
                    });
                }
            }
        }

        // دالة تحديث أرقام الترتيب
        function updateOrderNumbers() {
            var dropzone = document.getElementById('product-dropzone');
            var previews = dropzone.querySelectorAll('.dz-preview');

            previews.forEach(function(preview, index) {
                var orderElement = preview.querySelector('.dz-order');
                if (orderElement) {
                    orderElement.textContent = index + 1;
                } else {
                    preview.innerHTML += '<div class="dz-order">' + (index + 1) + '</div>';
                }
            });
        }

        // دالة حفظ ترتيب الصور
        function saveImageOrder() {
            var dropzone = document.getElementById('product-dropzone');
            var previews = dropzone.querySelectorAll('.dz-preview');
            var imageIds = [];

            previews.forEach(function(preview) {
                var imageId = preview.getAttribute('data-image-id');
                if (imageId) {
                    imageIds.push(imageId);
                }
            });

            if (imageIds.length > 0) {
                $.ajax({
                    url: window.routes.updateImageOrder,
                    type: 'POST',
                    data: {
                        image_ids: imageIds,
                        product_id: window.productId,
                        _token: window.csrfToken
                    },
                    success: function(response) {
                        console.log('Image order updated successfully:', response);
                    },
                    error: function(xhr, status, error) {
                        console.error('Error updating image order:', error);
                    }
                });
            }
        }
    });
    </script>

    <!-- TinyMCE Editor Component -->
    <!-- TinyMCE Self-hosted -->
    <script src="{{ asset('assets/dashboard/tinymce/tinymce.min.js') }}"></script>
    <script>
    // Initialize TinyMCE with proper settings to avoid API warnings
    document.addEventListener('DOMContentLoaded', function() {
        const textareas = document.querySelectorAll(
            'textarea[id$="_editor"], textarea[name*="long_desc"], textarea[name*="short_desc"]');

        textareas.forEach(function(textarea, index) {
            let uniqueId = textarea.id;
            if (!textarea.id) {
                uniqueId = 'tinymce_editor_' + index + '_' + textarea.name.replace(/[^a-zA-Z0-9]/g,
                    '_');
                textarea.id = uniqueId;
            }

            tinymce.init({
                selector: '#' + uniqueId,
                height: 400,
                menubar: false,
                plugins: [
                    'advlist', 'autolink', 'lists', 'link', 'image', 'charmap', 'preview',
                    'anchor', 'searchreplace', 'visualblocks', 'code', 'fullscreen',
                    'insertdatetime', 'media', 'table', 'help', 'wordcount',
                    'directionality'
                ],
                toolbar: 'undo redo | blocks | bold italic underline | alignleft aligncenter alignright | bullist numlist | link image | code help',
                content_style: 'body { font-family: Helvetica, Arial, sans-serif; font-size: 14px }',
                branding: false,
                promotion: false,
                license_key: 'gpl',
                setup: function(editor) {
                    editor.on('change', function() {
                        editor.save();
                    });
                }
            });
        });
    });
    </script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
    // CSRF Token
    var token = $('meta[name="csrf-token"]').attr('content') || '{{ csrf_token() }}';

    // Initialize Sortable for images
    document.addEventListener('DOMContentLoaded', function() {
        const sortableContainer = document.getElementById('sortable-images');
        if (sortableContainer) {
            new Sortable(sortableContainer, {
                animation: 150,
                ghostClass: 'sortable-ghost',
                chosenClass: 'sortable-chosen',
                dragClass: 'sortable-drag',
                handle: '.drag-handle',
                onStart: function(evt) {
                    console.log('Started dragging image');
                    // إظهار رسالة توضيحية عند بدء السحب
                    if (!document.getElementById('drag-hint')) {
                        const hint = document.createElement('div');
                        hint.id = 'drag-hint';
                        hint.className = 'alert alert-warning position-fixed';
                        hint.style.cssText =
                            'top: 20px; right: 20px; z-index: 9999; max-width: 300px;';
                        hint.innerHTML =
                            '<i class="fas fa-hand-paper me-2"></i>{{ __('
                        dashboard.drag_to_reorder ') }}';
                        document.body.appendChild(hint);

                        // إزالة الرسالة بعد 3 ثوان
                        setTimeout(() => {
                            if (hint.parentNode) {
                                hint.parentNode.removeChild(hint);
                            }
                        }, 3000);
                    }
                },
                onEnd: function(evt) {
                    console.log('Image order changed');
                    // إزالة الرسالة التوضيحية
                    const hint = document.getElementById('drag-hint');
                    if (hint && hint.parentNode) {
                        hint.parentNode.removeChild(hint);
                    }
                    // لا نحفظ الترتيب تلقائياً، فقط عند الضغط على زر "Save Order"
                }
            });
        }

        // Select All functionality
        const selectAllBtn = document.getElementById('select_all_btn');
        const deleteSelectedBtn = document.getElementById('delete_selected_btn');
        const checkboxes = document.querySelectorAll('.select_image_checkbox');

        if (selectAllBtn) {
            selectAllBtn.addEventListener('click', function() {
                const allChecked = Array.from(checkboxes).every(cb => cb.checked);
                checkboxes.forEach(cb => {
                    cb.checked = !allChecked;
                });
                selectAllBtn.textContent = allChecked ? '{{ __('
                dashboard.select_all ') }}':
                    '{{ __('
                dashboard.unselect_all ') }}';
            });
        }

        // Delete Selected functionality
        if (deleteSelectedBtn) {
            deleteSelectedBtn.addEventListener('click', function() {
                const selectedImages = Array.from(checkboxes)
                    .filter(cb => cb.checked)
                    .map(cb => cb.value);

                if (selectedImages.length === 0) {
                    alert('{{ __('
                        dashboard.please_select_images_to_delete ') }}');
                    return;
                }

                if (confirm('{{ __('
                        dashboard.confirm_delete_selected_images ') }}')) {
                    deleteSelectedImages(selectedImages);
                }
            });
        }

        // Individual delete buttons
        document.querySelectorAll('.delete_img_btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const imageId = this.getAttribute('data-image');
                if (confirm('{{ __('
                        dashboard.confirm_delete_this_image ') }}')) {
                    deleteImage(imageId);
                }
            });
        });

        // Delete All button
        document.querySelectorAll('.delete_all_img').forEach(btn => {
            btn.addEventListener('click', function() {
                const productId = this.getAttribute('data-id');
                if (confirm('{{ __('
                        dashboard.confirm_delete_all_images ') }}')) {
                    deleteAllImages(productId);
                }
            });
        });

        // أزرار إدارة الصور
        setupImageManagementButtons();
    });

    // إعداد أزرار إدارة الصور
    function setupImageManagementButtons() {
        console.log('Setting up image management buttons...');

        // زر تحديد الكل
        $('#select_all_images').on('click', function() {
            console.log('Select all clicked');
            $('.select_image_checkbox').prop('checked', true);
        });

        // زر إلغاء تحديد الكل
        $('#unselect_all_images').on('click', function() {
            $('.select_image_checkbox').prop('checked', false);
        });

        // زر حذف المحدد
        $('#delete_selected_images').on('click', function() {
            const selectedIds = $('.select_image_checkbox:checked').map(function() {
                return $(this).closest('.sortable-container').data('id');
            }).get();

            if (selectedIds.length === 0) {
                alert(window.translations.please_select_images_to_delete);
                return;
            }

            if (confirm(window.translations.confirm_delete_selected_images)) {
                deleteSelectedImages(selectedIds);
            }
        });

        // زر حذف الكل
        $('#delete_all_images').on('click', function() {
            if (confirm(window.translations.confirm_delete_all_images)) {
                deleteAllImages();
            }
        });

        // زر حفظ الترتيب
        $('#save_order_btn').on('click', function() {
            const images = Array.from(document.querySelectorAll('#sortable-images .sortable-container'));
            const order = images.map(img => img.getAttribute('data-id'));
            saveImageOrder(order);
        });
    }

    // حفظ ترتيب الصور
    function saveImageOrder(imageIds) {
        $.ajax({
            url: window.routes.reorderImages,
            method: 'POST',
            data: {
                image_ids: imageIds,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    alert('{{ __('
                        dashboard.order_saved_successfully ') }}');
                } else {
                    alert('Error: ' + (response.message || 'Failed to save order'));
                }
            },
            error: function() {
                alert('Error occurred while saving order');
            }
        });
    }

    // حذف الصور المحددة
    function deleteSelectedImages(imageIds) {
        $.ajax({
            url: window.routes.deleteSelectedImages,
            method: 'POST',
            data: {
                image_ids: imageIds,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (response.message || 'Failed to delete images'));
                }
            },
            error: function() {
                alert('Error occurred while deleting images');
            }
        });
    }

    // حذف جميع الصور
    function deleteAllImages() {
        $.ajax({
            url: window.routes.deleteAllImages,
            method: 'POST',
            data: {
                product_id: window.productId,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (response.message || 'Failed to delete all images'));
                }
            },
            error: function() {
                alert('Error occurred while deleting all images');
            }
        });
    }

    function deleteImage(imageId) {
        $.ajax({
            url: window.routes.deleteImage,
            method: 'POST',
            data: {
                image_id: imageId,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (response.message || 'Failed to delete image'));
                }
            },
            error: function() {
                alert('Error occurred while deleting image');
            }
        });
    }

    function deleteAllImages(productId) {
        $.ajax({
            url: window.routes.deleteAllImages,
            method: 'POST',
            data: {
                product_id: productId,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    location.reload();
                } else {
                    alert('Error: ' + (response.message || 'Failed to delete all images'));
                }
            },
            error: function() {
                alert('Error occurred while deleting all images');
            }
        });
    }

    function saveImageOrder(imageIds) {
        $.ajax({
            url: window.routes.reorderImages,
            method: 'POST',
            data: {
                image_ids: imageIds,
                _token: window.csrfToken
            },
            success: function(response) {
                if (response.success) {
                    alert('{{ __('
                        dashboard.order_saved_successfully ') }}');
                } else {
                    alert('Error: ' + (response.message || 'Failed to save order'));
                }
            },
            error: function(xhr) {
                let msg = 'Error occurred while saving order';
                if (xhr.status === 422 && xhr.responseJSON && xhr.responseJSON.message) {
                    msg = xhr.responseJSON.message;
                }
                alert(msg);
            }
        });
    }
    </script>
    @endsection

</x-dashboard.layout>