<?php

namespace App\Http\Requests\Dashboard\Phones;

use App\Traits\HasMultilingualValidation;
use Illuminate\Foundation\Http\FormRequest;

class StorePhoneRequest extends FormRequest
{
    use HasMultilingualValidation;

    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $rules = [
            'phone' => 'required|string|max:20',
            'code' => 'nullable|string|max:5',
            'email' => 'nullable|email|max:255',
            'type' => 'required|in:phone,whatsapp',
            'status' => 'boolean',
            'order' => 'nullable|integer',
        ];

        // Add multilingual validation rules
        $rules = array_merge($rules, $this->getMultilingualRules(['name', 'description']));

        return $rules;
    }

    /**
     * Get the validated data and convert multilingual fields to JSON format
     */
    public function validated($key = null, $default = null)
    {
        $data = parent::validated($key, $default);

        // Convert multilingual fields to JSON format
        $data['name'] = $this->convertToJsonField('name');
        $data['description'] = $this->convertToJsonField('description');

        return $data;
    }

    /**
     * Convert multilingual field data to JSON format
     */
    private function convertToJsonField(string $fieldName): array
    {
        $languages = config('app.form_languages', ['en', 'ar', 'fr']);
        $jsonData = [];

        foreach ($languages as $lang) {
            $value = $this->input($fieldName . '_' . $lang);
            if (!empty($value)) {
                $jsonData[$lang] = $value;
            }
        }

        return $jsonData;
    }
}