<div class="tf-mini-cart-main">
    <div class="tf-mini-cart-sroll">
        <div class="tf-mini-cart-items">
            <?php $__empty_1 = true; $__currentLoopData = $cart->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cardItem): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="tf-mini-cart-item">
                <div class="tf-mini-cart-image">
                    <a href="<?php echo e(route('product.details',$cardItem->product->link)); ?>">
                        <img src="<?php echo e($cardItem->variant?->first_image ?? $cardItem->product->main_image_path); ?>" alt="<?php echo e($cardItem->product->name); ?>">
                    </a>
                </div>
                <div class="tf-mini-cart-info">
                    <a class="title link" href="<?php echo e($cardItem->product->link); ?>">
                        <?php echo e($cardItem->product->name); ?>

                    </a>
                    
                    <?php if($cardItem->variant): ?>
                    <?php $__currentLoopData = $cardItem->variant->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <p><strong><?php echo e($value->value->attribute->name); ?></strong>: <?php echo e($value->value->value); ?></p>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php endif; ?>

                    
                    <?php if($cardItem->product->isOnSale($cardItem->variant?->id)): ?>
                    <div class="sale-price">
                        <strong>Now</strong>: <?php echo e(config('app.currency')); ?> <?php echo e($cardItem->product->getEffectivePrice($cardItem->variant?->id)); ?>

                    </div>
                    <div class="original-price">
                        <strong>Before sale price</strong>:
                        <del><?php echo e(config('app.currency')); ?> <?php echo e($cardItem->product->getOriginalPrice($cardItem->variant?->id)); ?></del>
                    </div>
                    <div class="save-discount">
                        <strong>Save</strong>: <?php echo e(config('app.currency')); ?> <?php echo e($cardItem->product->getDiscountAmount($cardItem->variant?->id)); ?>

                    </div>
                    <?php else: ?>
                    <strong class="original-price">
                        <?php echo e(config('app.currency')); ?> <?php echo e($cardItem->product->getOriginalPrice($cardItem->variant?->id)); ?>

                    </strong>
                    <?php endif; ?>

                    
                    <div class="tf-mini-cart-btns">
                        <div class="wg-quantity small">
                            <span class="btn-quantity minus-btn">-</span>
                            <input type="text" name="number" value="<?php echo e($cardItem->quantity); ?>">
                            <span class="btn-quantity plus-btn">+</span>
                        </div>
                        <div class="tf-mini-cart-remove" data-cart_item_id="<?php echo e($cardItem->id); ?>">Remove</div>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <?php echo $__env->make('website.layouts.modals.partials._empty_cart', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
        </div>

        
        <?php echo $__env->make('website.layouts.modals.partials._cart_recommendation_products', ['relatedProducts' => $related_cart_products], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        

          
        <?php if( $cart->total_price > 0): ?>
            <div class="tf-mini-cart-bottom">
                <div class="tf-mini-cart-bottom-wrap">
                    <div class="tf-cart-totals-discounts">
                        <div class="tf-cart-total">Subtotal</div>
                        <div class="tf-totals-total-value fw-6">
                            <?php echo e(config('app.currency') . ' ' . $cart->total_price); ?>

                        </div>
                    </div>
                    <div class="tf-cart-tax">
                        <?php echo e(__('home.Taxes and shipping calculated at checkout')); ?>

                    </div>
                    <div class="tf-mini-cart-line"></div>
    
                    <div class="tf-mini-cart-view-checkout">
                        <a href="<?php echo e(route('shopping-cart')); ?>" class="tf-btn btn-outline radius-3 link w-100 justify-content-center">
                            <?php echo e(__('home.View Cart')); ?>

                        </a>
                        <a href="<?php echo e(route('checkout')); ?>" class="tf-btn btn-fill animate-hover-btn radius-3 w-100 justify-content-center">
                            <span><?php echo e(__('home.checkout')); ?></span>
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
  
</div>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/layouts/modals/partials/shoppingCart-append.blade.php ENDPATH**/ ?>