<!-- mobile menu -->
<div class="offcanvas offcanvas-start canvas-mb" id="mobileMenu">
    <span class="icon-close icon-close-popup" data-bs-dismiss="offcanvas" aria-label="Close"></span>
    <div class="mb-canvas-content">
        <div class="mb-body">

            <ul class="nav-ul-mb" id="wrapper-menu-navigation">
                <!-- Insert logo  -->
                <li class="menu-item logo-link">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>" class="logo-header">
                        <img src="<?php echo e(config('site_logo')); ?>" alt="<?php echo e(config('app_name')); ?>" class="logo">
                    </a>
                </li>
                <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php if($menu->segment === 'home'): ?>
                <li class="nav-mb-item">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>" class="mb-menu-link current"><?php echo e($menu->name); ?></a>
                </li>
                <?php elseif($menu->segment === 'products'): ?>
                <li class="nav-mb-item">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl('products')); ?>" class="item-link">
                        <span><?php echo e($menu->name); ?></span>
                        
                    </a>
                    
                </li>
                <?php else: ?>
                <li class="nav-mb-item">
                    <a href="<?php echo e(LaravelLocalization::localizeUrl($menu->segment)); ?>" class="item-link"><?php echo e($menu->name); ?></a>
                </li>
                <?php endif; ?>

                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>


        </div>
        <div class="mb-bottom">
            <?php if(auth()->guard()->guest()): ?>
            <a href="<?php echo e(url('login')); ?>" class="site-nav-icon"><i class="icon icon-account"></i><?php echo e(__('home.login')); ?></a>

            <?php endif; ?>

            <div class="bottom-bar-language">
                
                <div class="tf-currencies dropdown">
                    <?php if(auth()->guard()->check()): ?>
                    <button class="btn btn-light dropdown-toggle" type="button" id="profileDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="<?php echo e(asset('assets/front/images/icon/profile-user.webp')); ?>" alt="Profile" width="30">
                        <?php echo e(Auth::user()->name); ?>

                    </button>
                    <ul class="dropdown-menu" aria-labelledby="profileDropdown">
                        <li><a class="dropdown-item" href="<?php echo e(LaravelLocalization::localizeUrl('account/profile')); ?>"><?php echo e(__('home.account_setting')); ?></a></li>
                        <li><a class="dropdown-item" href="<?php echo e(LaravelLocalization::localizeUrl('account/dashboard')); ?>"><?php echo e(Auth::user()->name); ?></a></li>
                        <li>
                            <a class="dropdown-item" href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                                <?php echo e(__('Logout')); ?>

                            </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    </ul>
                    <?php endif; ?>

                    <?php if(auth()->guard()->guest()): ?>
                    <button class="btn btn-light dropdown-toggle" type="button" id="guestDropdown" data-bs-toggle="dropdown" aria-expanded="false">
                        <img src="<?php echo e(asset('assets/front/images/icon/profile-user.webp')); ?>" alt="Profile" width="30">
                    </button>
                    <ul class="dropdown-menu" aria-labelledby="guestDropdown">
                        <li><a class="dropdown-item" href="<?php echo e(route('login')); ?>"><?php echo e(__('home.login')); ?></a></li>
                        <li><a class="dropdown-item" href="<?php echo e(route('register')); ?>"><?php echo e(__('home.register')); ?></a></li>
                    </ul>
                    <?php endif; ?>
                </div>


                <div class="tf-languages">
                    <a href="<?php echo e(LaravelLocalization::getCurrentLocale() === 'en' ? 'ar' : 'en'); ?>" id="toggle-rtl" class="tf-btn animate-hover-btn">
                        <img src="<?php echo e(asset('assets/front/images/icon/translationC.webp')); ?>" alt="lang_alt">
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- /mobile menu -->
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/headers/mobile-menu.blade.php ENDPATH**/ ?>