<?php $__env->startSection('meta'); ?>
    <title><?php echo e(trans('home.variants')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="spainer"></div>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.variants')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('/admin')); ?>"> <?php echo e(trans('home.admin')); ?></a>
                    </li>
                    <li class="breadcrumb-item">
                        <a href="<?php echo e(url('admin/products')); ?>"><?php echo e(trans('home.products')); ?> </a>
                    </li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/products/' . $product->id.'/edit')); ?>"><?php echo e($product->name); ?></a>
                    </li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.variants')); ?></li>
                </ol>
            </div>

        </div>
      <?php echo $__env->make('admin.products.variants.create', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.variants')); ?></h6>
                            <p class="text-muted card-sub-title">
                                <?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?>

                            </p>
                        </div>

                        <div class="table-responsive">
                            <table class="table" id="exportexample">
                                <thead>
                                    <tr>

                                        <th>#</th>
                                        <th><?php echo e(__('home.id')); ?></th>
                                        
                                        <th><?php echo e(trans('home.values')); ?></th>
                                        <th><?php echo e(trans('home.price')); ?></th>
                                        <th><?php echo e(trans('home.stock')); ?></th>
                                        <th><?php echo e(trans('home.edit')); ?></th>
                                        <th><?php echo e(__('home.images')); ?></th>
                                        <th><?php echo e(trans('home.delete')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $product->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr id="variant_<?php echo e($variant->id); ?>">
                                            <td><?php echo e($key + 1); ?></td>
                                            <td><?php echo e($variant->id); ?></td>
                                            

                                                <td>
                                                      <?php $__currentLoopData = $variant->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variantValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <span class="badge badge-primary"><?php echo e($variantValue->value->value); ?></span>
                                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>



                                            <td><?php echo e($variant->additional_price); ?></td>
                                            <td><?php echo e($variant->stock); ?></td>

                                            <td>
                                                    <button type="button" class="btn btn-info" data-toggle="modal" data-target="#variantForm_<?php echo e($variant->id); ?>">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                            </td>
                                            <td>
                                                <a href="<?php echo e(route('variants.images.index', [$variant->id])); ?>" class="btn btn-primary">
                                                    <i class="fas fa-image"></i>
                                                </a>
                                            </td>
                                            <td>
                                                <form action="<?php echo e(route('products.variants.destroy', [$product->id, $variant->id])); ?>" method="POST"  class="delete-form">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="submit" class="btn btn-danger btn-delete-form">
                                                        <i class="fas fa-trash-alt"></i>
                                                    </button>
                                                </form>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->

        <!-- Update-->
        <?php $__currentLoopData = $product->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="modal fade text-left" id="variantForm_<?php echo e($variant->id); ?>" tabindex="-1" role="dialog"
                aria-labelledby="variantEditModal<?php echo e($variant->id); ?>" aria-hidden="true">
                <div class="modal-dialog" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h3 class="modal-title" id="variantEditModal<?php echo e($variant->id); ?>"><?php echo e(trans('home.edit_product_varinats')); ?></h3>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                <span aria-hidden="true">&times;</span>
                            </button>
                        </div>

                       <?php echo $__env->make('admin.products.variants.update', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

         <!-- End Row -->

    </div>
    <?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/products/variants/index.blade.php ENDPATH**/ ?>