<?php $__env->startSection('meta'); ?>
<title><?php echo e(trans('home.edit_aboutStrucs')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.aboutStrucs')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/aboutStrucs')); ?>"><?php echo e(trans('home.aboutStrucs')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_aboutStruc')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_aboutStruc')); ?></h6>
                    </div>
                    <form method="post" action="<?php echo e(route('aboutStrucs.update',$aboutStruc->id)); ?>" enctype="multipart/form-data">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                <input class="form-control" name="name_en" type="text" value="<?php echo e($aboutStruc->name_en); ?>" placeholder="<?php echo e(trans('home.name_en')); ?>" required>
                            </div>

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                <input class="form-control" name="name_ar" type="text" value="<?php echo e($aboutStruc->name_ar); ?>" placeholder="<?php echo e(trans('home.name_ar')); ?>" required>
                            </div>
                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.text_ar')); ?></label>
                                <textarea class="form-control area1" name="text_ar" placeholder="<?php echo e(trans('home.text_ar')); ?>"><?php echo $aboutStruc->text_ar; ?></textarea>
                            </div>

                            <div class="form-group col-md-6">
                                <label class=""><?php echo e(trans('home.text_en')); ?></label>
                                <textarea class="form-control area1" name="text_en" placeholder="<?php echo e(trans('home.text_ar')); ?>"><?php echo $aboutStruc->text_en; ?></textarea>
                            </div>


                            <div class="form-group  col-md-10">
                                <label><?php echo e(trans('home.image')); ?></label>
                                <div class="input-group mb-1">
                                    <div class="input-group-prepend">
                                        <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                    </div>
                                    <div class="custom-file">
                                        <input type="file" class="custom-file-input" name="image">
                                        <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group  col-md-2">
                                <img src="<?php echo e($aboutStruc->image_path); ?>" width="200" height="150">
                            </div>
                            <br>
                            <div class="form-group col-md-4">
                                <label class="ckbox">
                                    <input name="status" value="1" <?php echo e(($aboutStruc->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                </label>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin/aboutStrucs')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>

                        </div>
                    </form>


                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/aboutStrucs/editAboutStruc.blade.php ENDPATH**/ ?>