<title><?php echo e($attribute->name); ?> <?php echo e(__('home.values')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.attributes_values')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item"><a href="<?php echo e(url('admin/attributes')); ?>"><?php echo e(trans('home.attributes')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e($attribute->name); ?> <?php echo e(__('home.values')); ?></li>
            </ol>
        </div>
    </div>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">
                <div class="card-body">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.add_attribute_values')); ?></h6>
                    </div>
                    <form action="<?php echo e(route('attributes.values.store',[$attribute->id])); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                        <div class="border">

                            <form action="<?php echo e(route('attributes.values.store',[$attribute->id])); ?>" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">

                                    <div class="form-group col-md-4">
                                        <label class=""><?php echo e(__('home.value_ar')); ?></label>
                                        <input class="form-control" name="value_ar" type="text" value="<?php echo e(old('value_ar')); ?>" placeholder="<?php echo e(__('home.value_ar')); ?>">
                                    </div>

                                    <div class="form-group col-md-4">
                                        <label class=""><?php echo e(__('home.value_en')); ?></label>
                                        <input class="form-control" name="value_en" type="text" value="<?php echo e(old('value_en')); ?>" placeholder="<?php echo e(__('home.value_en')); ?>">
                                    </div>

                                    <?php if($attribute->isColor()): ?>
                                    <div class="form-group col-md-2">
                                        <label class=""><?php echo e(__('home.code')); ?></label>
                                        <input type="color" class="form-control" name="code" type="text" placeholder="<?php echo e(__('home.code')); ?>">
                                    </div>
                                    <?php endif; ?>

                                    <div class="form-group col-md-2">
                                        <div class="d-flex flex-wrap gap-2">

                                            <h5 class="font-size-14 mb-3"><?php echo e(__('home.publish/unpublish')); ?> </h5>

                                            <input type="checkbox" id="switch1" switch="none" value="1" name="status" checked />
                                            <label for="switch1" data-on-label="<?php echo e(__('home.yes')); ?>" data-off-label="<?php echo e(__('home.no')); ?>"></label>
                                        </div>
                                    </div>


                                    <div class="form-group col-md-12">
                                        <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                            <?php echo e(__('Save changes')); ?> </button>
                                        <a href="<?php echo e(route('attributes.edit',[$attribute->id])); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                                <?php echo e(__('home.cancel')); ?></button></a>
                                    </div>

                                </div>
                            </form>

                        </div>

                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/attribute-values/create.blade.php ENDPATH**/ ?>