<script>
   $(document).ready(function() {
    // When Governorate is selected
    $('.governorate').on('change', function() {
        var governorateId = $(this).val(); // Get the selected Governorate ID
        updateShippingFees(governorateId, null);
    });

   
    // Function to update shipping fees
    function updateShippingFees(governorateId) {
    $.ajax({
        url: '/get-shipping-fees',
        method: 'POST',
        data: {
            governorate_id: governorateId,
            _token: '<?php echo e(csrf_token()); ?>' // CSRF Token for Laravel
        },
        success: function(response) {
            // Update the total price in the UI
            $('.grand-total').text( response.currency + ' ' + response.grand_total);
            $('.shipping-fees').text( response.currency + ' ' + response.shipping_fees); // Update shipping fees display
            $('.simple-request-shipping-fees').text( response.currency + ' ' + response.simple_request_shipping_fees); // Update shipping fees for simple request
          
         
        },
        error: function() {
            $('.shipping-fees').text('Error fetching shipping fees'); // Handle errors
        }
    });
}
});

</script>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/scripts/checkout/shipping-selection.blade.php ENDPATH**/ ?>