<script>
    $(document).ready(function() {
        // Initialize auto-complete
        auto();

        function auto() {
            var options = {
                url: function(phrase) {
                    return "<?php echo e(url('search')); ?>?query=" + phrase; // Pass the query parameter
                },
                ajaxSettings: {
                    dataType: "json",
                    method: "GET"
                },
                getValue: function(element) {
                    // Determine the field to use based on the current locale
                    return "<?php echo e(app()->getLocale() === 'ar' ? 'name_ar' : 'name_en'); ?>" === 'name_ar' ? element.name_ar : element.name_en;
                },
                list: {
                    maxNumberOfElements: 10,
                    match: {
                        enabled: true
                    },
                    onChooseEvent: function() {
                        // Get the selected product
                        var selectedProduct = $('.autoCompleteProduct').getSelectedItemData();

                        // Determine the link based on the current locale
                        var productLink = "<?php echo e(app()->getLocale() === 'ar' ? 'link_ar' : 'link_en'); ?>";

                        // Redirect to the product page using the appropriate link
                        if (selectedProduct && selectedProduct[productLink]) {
                            window.location.href = "<?php echo e(LaravelLocalization::localizeUrl('product')); ?>/" + selectedProduct[productLink];
                        }
                    }
                },
                requestDelay: 300 // Add a delay to reduce AJAX requests
            };

            $('.autoCompleteProduct').easyAutocomplete(options);
        }
    });
    </script><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/scripts/autocomplete-search.blade.php ENDPATH**/ ?>