@extends('layouts.app')
@section('meta')
    <title{{ Auth::user()->name }}</title>
@endsection
@section('content')

<!-- page-title -->
<div class="tf-page-title">
    <div class="container">
        <div class="heading text-center">{{ __('home.hello') . ' ' . Auth::user()->name }}</div>
    </div>
</div>
<!-- /page-title -->


<!-- page-cart -->
<section class="flat-spacing-11">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <div class="wrap-sidebar-account">
                   @include('website.userBoard.partials.account-nav')
                </div>
            </div>
            <div class="col-lg-9">
                <div class="my-account-content account-dashboard">
                    <div class="mb_60">
                        <h5 class="fw-5 mb_20">{{ __('home.hello') . ' ' . Auth::user()->name }}</h5>
                        <p>
                            {{ __('home.From your account dashboard you can view your') }} <a class="text_primary" href="{{ LaravelLocalization::LocalizeUrl('account/orders') }}">{{__('home.recent orders')}}</a>,{{ __('home.manage your') }} <a class="text_primary" href="{{ LaravelLocalization::LocalizeUrl('account/addresses') }}">{{ __('home.shipping and billing address') }}</a>, and <a class="text_primary" href="{{ LaravelLocalization::LocalizeUrl('account/profile') }}">{{ __('home.edit your password and account details') }}</a>.
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- page-cart -->
@endsection