@extends('layouts.app')
@section('meta')
<title>{{ __('home.shopping_cart') }}</title>
@endsection
@section('content')

@include('website._breadcrumb', ['page_title' => __('home.shopping_cart')])


{{-- Shopping Cart Section   --}}
<section class="flat-spacing-11">
    <div class="container">
        <div class="tf-cart-countdown">
            <div class="title-left">
                <svg class="d-inline-block" xmlns="http://www.w3.org/2000/svg" width="16" height="24" viewBox="0 0 16 24" fill="rgb(219 18 21)">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M10.0899 24C11.3119 22.1928 11.4245 20.2409 10.4277 18.1443C10.1505 19.2691 9.64344 19.9518 8.90645 20.1924C9.59084 18.2379 9.01896 16.1263 7.19079 13.8576C7.15133 16.2007 6.58824 17.9076 5.50148 18.9782C4.00436 20.4517 4.02197 22.1146 5.55428 23.9669C-0.806588 20.5819 -1.70399 16.0418 2.86196 10.347C3.14516 11.7228 3.83141 12.5674 4.92082 12.8809C3.73335 7.84186 4.98274 3.54821 8.66895 0C8.6916 7.87426 11.1062 8.57414 14.1592 12.089C17.4554 16.3071 15.5184 21.1748 10.0899 24Z">
                    </path>
                </svg>
                <p>These products are limited, checkout within </p>
            </div>

        </div>
        <div class="tf-page-cart-wrap">
            <div class="tf-page-cart-item">
                
                    <table class="tf-table-page-cart">
                        <thead>
                            <tr>
                                <th>{{ __('home.product') }}</th>
                                <th>{{ __('home.price') }}</th>
                                <th>{{ __('home.quantity') }}</th>
                                <th>{{ __('home.total') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($cart->items as $cartItem )

                            <tr class="tf-cart-item file-delete">
                                <td class="tf-cart-item_product">
                                    <a href="{{ route('product.details',$cartItem->product->link) }}" class="img-box">
                                        @if($cartItem->product_variant_id)
                                        <img src="{{$cartItem->variant->first_image }}" alt="{{ $cartItem->product->name }}">
                                        @else

                                        <img src="{{ $cartItem->product->main_image_path }}" alt="{{ $cartItem->product->name }}">
                                        @endif
                                    </a>

                                    <div class="cart-info">
                                        <a href="{{ route('product.details',$cartItem->product->link) }}" class="cart-title link">{{ $cartItem->product->name }}</a>
                                        {{-- Variant Attributes --}}
                                        @if ($cartItem->variant)

                                        @foreach ($cartItem->variant->values as $value)
                                        <p><strong>{{ $value->value->attribute->name }}</strong>: {{ $value->value->value }}</p>
                                        @endforeach

                                        @endif
                                        <span class="remove-cart link remove">Remove</span>
                                    </div>

                                </td>
                                <td class="tf-cart-item_price tf-variant-item-price" cart-data-title="Price">
                                    <div class="cart-price price">

                                        @if($cartItem->product->isOnSale($cartItem->product_variant_id))
                                        <div class="sale-price">
                                            <strong>Now:</strong> {{ config('app.currency') }} {{ $cartItem->product->getEffectivePrice($cartItem->product_variant_id) }}
                                        </div>
                                        <div class="original-price">
                                            <strong>Before sale price:</strong>
                                            <del>{{ config('app.currency') }} {{ $cartItem->product->getOriginalPrice($cartItem->product_variant_id) }}</del>
                                        </div>
                                        <div class="save-discount">
                                            <strong>Save:</strong> {{ config('app.currency') }} {{ $cartItem->product->getDiscountAmount($cartItem->product_variant_id) }}
                                        </div>
                                        @else
                                        <span class="original-price">{{ config('app.currency') }} {{ $cartItem->product->getOriginalPrice($cartItem->product_variant_id) }}</span>
                                        @endif


                                    </div>
                                </td>
                                <td class="tf-cart-item_quantity" cart-data-title="Quantity">
                                    <div class="cart-quantity">
                                        <div class="wg-quantity">
                                            <span class="btn-quantity btndecrease">
                                                <svg class="d-inline-block" width="9" height="1" viewBox="0 0 9 1" fill="currentColor">
                                                    <path d="M9 1H5.14286H3.85714H0V1.50201e-05H3.85714L5.14286 0L9 1.50201e-05V1Z">
                                                    </path>
                                                </svg>
                                            </span>
                                            <input type="text" name="number" value="{{ $cartItem->quantity }}">
                                            <span class="btn-quantity btnincrease">
                                                <svg class="d-inline-block" width="9" height="9" viewBox="0 0 9 9" fill="currentColor">
                                                    <path d="M9 5.14286H5.14286V9H3.85714V5.14286H0V3.85714H3.85714V0H5.14286V3.85714H9V5.14286Z">
                                                    </path>
                                                </svg>
                                            </span>
                                        </div>
                                    </div>
                                </td>
                                <td class="tf-cart-item_total tf-variant-item-total" cart-data-title="Total">
                                    <div class="cart-total price">{{ config('app.currency') }} {{ $cartItem->item_total_price }}</div>
                                </td>
                            </tr>
                            @empty

                            @endforelse


                        </tbody>
                    </table>
                 
                
            </div>
            <div class="tf-page-cart-footer">
                <div class="tf-cart-footer-inner">
                    <div class="tf-free-shipping-bar">
                        <div class="tf-progress-bar">
                            <span style="width: 50%;">
                                <div class="progress-car">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="21" height="14" viewBox="0 0 21 14" fill="currentColor">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M0 0.875C0 0.391751 0.391751 0 0.875 0H13.5625C14.0457 0 14.4375 0.391751 14.4375 0.875V3.0625H17.3125C17.5867 3.0625 17.845 3.19101 18.0104 3.40969L20.8229 7.12844C20.9378 7.2804 21 7.46572 21 7.65625V11.375C21 11.8582 20.6082 12.25 20.125 12.25H17.7881C17.4278 13.2695 16.4554 14 15.3125 14C14.1696 14 13.1972 13.2695 12.8369 12.25H7.72563C7.36527 13.2695 6.39293 14 5.25 14C4.10706 14 3.13473 13.2695 2.77437 12.25H0.875C0.391751 12.25 0 11.8582 0 11.375V0.875ZM2.77437 10.5C3.13473 9.48047 4.10706 8.75 5.25 8.75C6.39293 8.75 7.36527 9.48046 7.72563 10.5H12.6875V1.75H1.75V10.5H2.77437ZM14.4375 8.89937V4.8125H16.8772L19.25 7.94987V10.5H17.7881C17.4278 9.48046 16.4554 8.75 15.3125 8.75C15.0057 8.75 14.7112 8.80264 14.4375 8.89937ZM5.25 10.5C4.76676 10.5 4.375 10.8918 4.375 11.375C4.375 11.8582 4.76676 12.25 5.25 12.25C5.73323 12.25 6.125 11.8582 6.125 11.375C6.125 10.8918 5.73323 10.5 5.25 10.5ZM15.3125 10.5C14.8293 10.5 14.4375 10.8918 14.4375 11.375C14.4375 11.8582 14.8293 12.25 15.3125 12.25C15.7957 12.25 16.1875 11.8582 16.1875 11.375C16.1875 10.8918 15.7957 10.5 15.3125 10.5Z">
                                        </path>
                                    </svg>
                                </div>
                            </span>
                        </div>
                        @if(config('setting_free_amount' , 0) > 0)
                        <div class="tf-progress-msg">
                            Buy <span class="price fw-6">{{ config('app.currency') }}{{ config('setting_free_amount') }} </span> more to enjoy <span class="fw-6">Free
                                Shipping</span>
                        </div>
                        @endif
                    </div>
                    <form action="{{ route('checkout') }}" method="get">
                        @csrf
                       
                        <div class="tf-page-cart-checkout">

                            <div class="tf-cart-totals-discounts">
                                <h3>{{ __('home.subtotal') }}</h3>
                                <span class="total-value">{{ config('app.currency') }} {{ $cart->total_price }}</span>
                            </div>
                            <p class="tf-cart-tax">
                                Taxes and  shipping calculated at checkout
                            </p>
                            <div class="cart-checkbox">
                                <input type="checkbox" class="tf-check" id="check-agree" required>
                                <label for="check-agree" class="fw-4">
                                    I agree with the <a href="{{ LaravelLocalization::LocalizeUrl('page/terms-of-service')  }}">{{ __('home.terms and conditions') }}</a>
                                </label>
                            </div>
                            <div class="cart-checkout-btn">
                                <button type="submit" class="tf-btn w-100 btn-fill animate-hover-btn radius-3 justify-content-center">
                                    <span>Check out</span>
                                </button>
                            </div>
                            <div class="tf-page-cart_imgtrust">
                                <p class="text-center fw-6">Guarantee Safe Checkout</p>
                                <div class="cart-list-social">
                                   @forelse ($payment_logos as $payment_logo )
                                        <div class="payment-item">
                                            <img src="{{ $payment_logo->image_source }}" alt="{{ $payment_logo->name }}" title="{{ $payment_logo->name }}">
                                        </div>
                                    @empty
                                        
                                    @endforelse
                                   
                                    
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection
