<script>
    $(document).ready(function() {
        // Initialize auto-complete
        auto();

        function auto() {
            var options = {
                url: function(phrase) {
                    return "{{ url('search') }}?query=" + phrase; // Pass the query parameter
                },
                ajaxSettings: {
                    dataType: "json",
                    method: "GET"
                },
                getValue: function(element) {
                    // Determine the field to use based on the current locale
                    return "{{ app()->getLocale() === 'ar' ? 'name_ar' : 'name_en' }}" === 'name_ar' ? element.name_ar : element.name_en;
                },
                list: {
                    maxNumberOfElements: 10,
                    match: {
                        enabled: true
                    },
                    onChooseEvent: function() {
                        // Get the selected product
                        var selectedProduct = $('.autoCompleteProduct').getSelectedItemData();

                        // Determine the link based on the current locale
                        var productLink = "{{ app()->getLocale() === 'ar' ? 'link_ar' : 'link_en' }}";

                        // Redirect to the product page using the appropriate link
                        if (selectedProduct && selectedProduct[productLink]) {
                            window.location.href = "{{ LaravelLocalization::localizeUrl('product') }}/" + selectedProduct[productLink];
                        }
                    }
                },
                requestDelay: 300 // Add a delay to reduce AJAX requests
            };

            $('.autoCompleteProduct').easyAutocomplete(options);
        }
    });
    </script>