 <form action="{{ route('variants.get') }}" method="GET" id="variant-form">
     <input type="hidden" name="product_id" value="{{ $product->id }}">
     @foreach ($product->attributes as $productAttribute)
     @php
     $attributeName = $productAttribute->attribute->name;
     $attributeId = $productAttribute->attribute_id;
     $variantValues = $product->variants->flatMap(function($variant) use ($attributeId) {
     return $variant->values->filter(function($value) use ($attributeId) {
     return $value->value->attribute_id == $attributeId;
     });
     })->unique('value_id')->values();
     @endphp
     <div class="variant-picker-item">
         <div class="variant-picker-label">
             {{ $attributeName }}:
             <span class="fw-6 variant-picker-label-value value-current-{{ strtolower($attributeName) }}">
                 {{ $variantValues->first()->value->value ?? '' }}
             </span>
         </div>
         <div class="variant-picker-values">
             @foreach ($variantValues as $key => $variantValue)
             @php
             $value = $variantValue->value;
             $inputId = 'values-' . strtolower($value) . '-' . $attributeId;
             $isChecked = $key === 0;
             @endphp

             <input type="radio" name="variant[{{ $attributeId }}]" value="{{ $variantValue->value_id }}" data-value="{{  $value->value}}" data-attribute="{{ $attributeName }}" id="{{ $inputId }}" @checked($isChecked) hidden>

             @if (strtolower($attributeName) === 'color')
             <label class="hover-tooltip radius-60 color-btn" for="{{ $inputId }}" data-color="{{ $value->value }}" data-value="{{ $value->value }}">
                 <span class="btn-checkbox" style="background-color:{{ $value->code }}"></span>
                 <span class="tooltip">{{ ucfirst($value->value) }}</span>
             </label>
             @else
             <label class="style-text size-btn" for="{{ $inputId }}" data-value="{{ $value->value }}">
                 <p>{{ $value->value }}</p>
             </label>
             @endif
             @endforeach
         </div>
     </div>
     @endforeach
 </form>
