@extends('layouts.app')
<title> {{ config('site_app_name') }} @lang('home.register') </title>
@section('content')
 <!-- page-title -->
 <div class="tf-page-title style-2">
    <div class="container">
        <div class="heading text-center">{{  __('home.register') }}</div>
    </div>
</div>
<!-- /page-title -->

<section class="flat-spacing-10">
    <div class="container">
        <div class="form-register-wrap">
            <div class="flat-title align-items-start gap-0 mb_30 px-0">
                <h5 class="mb_18">{{  __('home.Register') }}</h5>
                <p class="text_black-2">{{  __('home.register_text') }}</p>
            </div>
            <div>
                <form class="" id="register-form" method="POST" action="{{ route('register') }}" accept-charset="utf-8" data-mailchimp="true">

                    @csrf

                    <div class="tf-field style-1 mb_15">

                        <input class="tf-field-input tf-input @error('f_name') is-invalid @enderror" placeholder="{{ trans('home.f_name') }} " type="text" id="property1" name="f_name">
                        <label class="tf-field-label fw-4 text_black-2" for="property1">{{ trans('home.f_name') }}</label>

                        @error('f_name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror

                    </div>

                    <div class="tf-field style-1 mb_15">

                        <input class="tf-field-input tf-input @error('l_name') is-invalid @enderror" placeholder="{{ trans('home.l_name') }}* " type="text" id="property2" name="l_name" >
                        <label class="tf-field-label fw-4 text_black-2" for="property2">{{ trans('home.l_name') }}*</label>

                        @error('l_name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror

                    </div>

                    <div class="tf-field style-1 mb_15">
                        <input class="tf-field-input tf-input @error('email') is-invalid @enderror" placeholder="{{  __('home.email') }} " value="{{ old('email') }}" type="email" id="property3" name="email" autocomplete="email" required>
                        <label class="tf-field-label fw-4 text_black-2" for="property3">{{  __('home.email') }} *</label>

                        @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                        
                    </div>
                    <div class="tf-field style-1 mb_30">

                        <input class="tf-field-input tf-input @error('password') is-invalid @enderror" required placeholder="{{  __('home.Password') }} " type="password" id="property4" name="password">
                        <label class="tf-field-label fw-4 text_black-2" for="property4">{{  __('home.password') }} *</label>

                        @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror

                    </div>
                    <div class="tf-field style-1 mb_30">
                        <input class="tf-field-input tf-input @error('password_confirmation') is-invalid @enderror" required placeholder=" {{  __('home.Confirm Password') }}" type="password" name="password_confirmation">
                        <label class="tf-field-label" for="">{{  __('home.Confirm Password') }}</label>
                        @error('password_confirmation')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                        @enderror
                    </div>

                    <div class="mb_20">
                        <button type="submit" class="tf-btn w-100 radius-3 btn-fill animate-hover-btn justify-content-center">{{  __('home.register') }}</button>
                    </div>
                    <div class="text-center">
                        <a href="{{ route('login') }}" class="tf-btn btn-line">{{  __('home.Already have an account?') }} <i class="icon icon-arrow1-top-left"></i></a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

@endsection