<div class="row">
    <div class="col-sm-12 col-xl-12 col-lg-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-body">
                <form action="{{ route('products.variants.update', [$product->id, $variant->id]) }}" method="POST">
                    @csrf
                    @method('PATCH')
                    <div class="row">
                        <!-- Attribute Values -->
                        <div class="form-group col-md-4">
                            <label>{{ __('home.attribute_value') }}</label>
                            <select class="form-control select2" name="value_ids[]" multiple>
                                <option value="">{{ __('home.choose_value') }}</option>
                                @foreach($product_attributes as $product_attribute)
                                    @foreach($product_attribute->attribute->values as $value)
                                        <option value="{{ $value->id }}"
                                                @selected(in_array($value->id, old('value_ids', $variant->values->pluck('value_id')->toArray())) )>
                                            {{ $product_attribute->attribute->name }}: {{ $value->value }}
                                        </option>
                                    @endforeach
                                @endforeach
                            </select>
                            @error('value_ids.*') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                        <!-- Additional Price -->
                        <div class="form-group col-md-4">
                            <label>{{ trans('home.price') }}</label>
                            <input class="form-control" name="additional_price" type="number" step="0.01" min="0"
                                   placeholder="{{ trans('home.price') }}" value="{{ old('additional_price', $variant->additional_price) }}">
                            @error('additional_price') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>

                        <!-- Stock -->
                        <div class="form-group col-md-4">
                            <label>{{ trans('home.stock') }}</label>
                            <input class="form-control" name="stock" type="number" min="0"
                                   placeholder="{{ trans('home.stock') }}" value="{{ old('stock', $variant->stock) }}">
                            @error('stock') <span class="text-danger">{{ $message }}</span> @enderror
                        </div>
                    </div>

                    <div class="row">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-info">{{ trans('home.update') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>