@extends('layouts.admin')
@section('meta')
    <title>{{trans('home.edit_configration')}} {{trans("home.$lang")}}</title>
@endsection
@section('content')

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5">{{trans('home.edit_configration')}} {{trans("home.$lang")}}</h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{url('/admin')}}">{{trans('home.admin')}}</a></li>
                    <li class="breadcrumb-item active" aria-current="page">{{trans('home.edit_configration')}} {{trans("home.$lang")}}</li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        @if(session()->has('success'))
            <div class="alert alert-success">
                {{ session()->pull('success') }}
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        @endif

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">

                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1">{{trans('home.edit_configration')}} {{trans("home.$lang")}}</h6>
                        </div>
                        <form action="{{ route('configrations.update',$lang) }}" method="POST" enctype="multipart/form-data">
                            @csrf
                            @method('PATCH')
                           
                            <div class="row">
                                <div class="form-group col-md-12 ">
                                    <fieldset class="form-group">
                                        <label for="title_en">{{ __('home.app_name') }}</label>
                                        <input type="text" class="form-control"  name="app_name" value="{{ $configrations['app_name'] }}">
                                    </fieldset>
                                </div>
    
    
                                <div class="form-group col-md-4">
                                    <label class="">{{__('home.top_text')}}</label>
                                    <textarea class="form-control" id="myeditorinstance" name="top_text" type="text" >{!!$configrations['top_text'] !!}</textarea>
                                </div>

                                <div class="form-group col-md-4">
                                    <label class="">{{__('home.site_description')}}</label>
                                    <textarea class="form-control" id="myeditorinstance" name="site_description" type="text" >{!!$configrations['site_description'] !!}</textarea>
                                </div>
    
                                <div class="form-group col-md-4">
                                    <label class="">{{__('home.footer_text')}}</label>
                                    <textarea class="form-control" id="myeditorinstance" name="footer_text" type="text" >{!!$configrations['footer_text'] !!}</textarea>
                                </div>
    
    
    
                                <div class="form-group col-md-4">
                                    <label>{{trans('home.app_logo')}}</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> {{trans('home.upload')}}</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="logo">
                                            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-4">
                                    <label>{{trans('home.app_footer_logo')}}</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> {{trans('home.upload')}}</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="footer_logo">
                                            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-4">
                                    <label>favicon</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> {{trans('home.upload')}}</span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="favicon">
                                            <label class="custom-file-label" for="inputGroupFile01">{{trans('home.choose_image')}}</label>
                                        </div>
                                    </div>
                                </div>

                             
                                <div class="form-group col-md-4">
                                    <img src="{{$configrations['logo']}}" width="150">
                                </div>



                                <div class="form-group col-md-4">
                                    <img src="{{ $configrations['footer_logo']}}" width="150">
                                </div>

                                <div class="form-group col-md-4">
                                    <img src="{{$configrations['favicon']}}" width="150">
                                </div>

                            

    
                                <div class="form-group col-md-12">
                                    <label class="">{{__('home.copyright')}}</label>
                                    <textarea class="form-control"  name="copyright" type="text" >{!!$configrations['copyright'] !!}</textarea>
                                </div>
    
    
    
                                <div class="form-group col-md-12 mt-3">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                        {{__('home.update')}} </button>
                                    <a href="{{route('configrations.edit','ar')}}"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i>
                                            {{__('home.cancel')}}</button></a>
                                </div>
    
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

@endsection
