<!-- Table -->
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header d-flex justify-content-between">
                <h4 class="card-title pt-3">{{ __('home.values') }}</h4>

                <div class="btn btn-list">
                    <a class="btn ripple btn-primary" href="{{ route('attributes.values.create',[$attribute->id]) }}"><i class="fas fa-plus-circle"></i> Add attribute values</a>

                </div>
            </div>
            <div class="card-body">
                <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                    <thead>
                        <tr>
                            <th><input type="checkbox" id="checkAll" /></th>
                            <th>{{ __('home.id') }}</th>
                            <th>{{ __('home.value_en') }}</th>
                            <th>{{ __('home.value_ar') }}</th>
                            <th>{{ __('home.code') }}</th>
                            <th>{{ __('home.status') }}</th>

                            <th>{{ __('home.actions') }}</th>
                        </tr>
                    </thead>


                    <tbody>
                        @foreach($attribute->values as $value)
                        <tr id="row-{{ $value->id }}">
                            <td><input type="checkbox" name="checkbox" class="tableChecked" value="{{ $value->id }}" />
                            </td>
                            <td>{{ $value->id }}</td>
                            <td>{{ $value->value_en }}</td>
                            <td>{{ $value->value_ar }}</td>
                            <td>{{ $value->code}}</td>
                            <td>
                                @if($value->status == 1)
                                {{ __('home.yes') }}
                                @else
                                {{ __('home.no') }}
                                @endif
                            </td>
                            <td>
                                <!-- Edit Modal Button -->
                               
                                <button type="button" class="btn btn-secondary waves-effect" data-bs-toggle="modal" data-bs-target="#editModal-{{ $value->id }}">
                                    {{ __('home.edit') }}
                                </button>
                                
                                <form action="{{ route('attributes.values.destroy',[$attribute->id,$value->id]) }}" method="POST">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-danger waves-effect waves-light">{{
                                        __('home.delete') }}</button>
                                </form>

                            </td>
                        </tr>


                        <!-- Include the Edit Modal -->
                        @include('admin.attribute-values.edit', ['value' => $value])
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <!-- end cardaa -->
    </div> <!-- end col -->
</div>
<!-- end row -->
