<?php

namespace Database\Seeders;

use App\Models\Attribute;
use App\Models\Product;
use App\Models\ProductAttribute;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class ProductAttributeSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = Product::all();
        $attributeIds = Attribute::where('status', true)->pluck('id');

        $products->each(function ($product) use ($attributeIds) {
            if (rand(0, 100) <= 60 && $attributeIds->isNotEmpty()) {
                $randomCount = min(rand(1, 5), $attributeIds->count());
                $randomAttributeIds = $attributeIds->random($randomCount);

                $product->attributes()->createMany(
                    $randomAttributeIds->map(fn($id) => ['attribute_id' => $id])
                );
            }
        });
    }
}
