<?php

namespace Database\Seeders;

use App\Models\Page;
use Illuminate\Database\Seeder;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $pages = [
            [
                'title_en' => 'Privacy Policy',
                'title_ar' => 'سياسة الخصوصية',
                'text_en' => 'The Company Private Limited Policy... (full text here)',
                'text_ar' => 'سياسة شركة ذا كومباني برايفت ليمتد... (full text here)',
                'link_en' => 'privacy-policy',
                'link_ar' => 'سياسة-الخصوصية',
                'status' => 1,
                'index' => 1,
            ],
            [
                'title_en' => 'Terms of Service',
                'title_ar' => 'شروط الخدمة',
                'text_en' => 'These Terms and Conditions May Change... (full text here)',
                'text_ar' => 'قد تتغير هذه الشروط والأحكام... (full text here)',
                'link_en' => 'terms-of-service',
                'link_ar' => 'شروط-الخدمة',
                'status' => 1,
                'index' => 1,
            ],
            [
                'title_en' => 'Refund Policy',
                'title_ar' => 'سياسة الاسترجاع',
                'text_en' => 'Delivery\nAll orders shipped with UPS Express... (full text here)',
                'text_ar' => 'التوصيل\nيتم شحن جميع الطلبات عبر UPS Express... (full text here)',
                'link_en' => 'refund-policy',
                'link_ar' => 'سياسة-الاسترجاع',
                'status' => 1,
                'index' => 1,
            ],
            [
                'title_en' => 'Shipping & Delivery',
                'title_ar' => 'الشحن والتسليم',
                'text_en' => 'NOTE:
*Avoid any delivery delay by providing your full address along with your contact details.

*If you need to change your delivery address after you have successfully placed your order,
please contact our online customer service department.
*In case of missing or uncompleted shipping address, the online customer service department will contact you to confirm on the address, if there was no response, the order will be cancelled within 24 hours.




Shipping Duration مدة زمن الشحن
Within 2-3 business days خلال٢-٣ ايام عمل
Zone 1 منطقه 1


Within 3-4 business days
Zone 2 - Zone 3 خلال ٣-٤ ايام عمل
منطقه 2 - منطقه 3


Within 4-5 business days خلال ٤-٥ ايام عمل
Zone 4 منطقة 4


Within 5-7 business days خلال ٥- ٧ ايام عمل
Zone 5 - Zone 6 منطقة 5 - منطقة 6 ',
                'text_ar' => 'NOTE:
*Avoid any delivery delay by providing your full address along with your contact details.

*If you need to change your delivery address after you have successfully placed your order,
please contact our online customer service department.
*In case of missing or uncompleted shipping address, the online customer service department will contact you to confirm on the address, if there was no response, the order will be cancelled within 24 hours.




Shipping Duration مدة زمن الشحن
Within 2-3 business days خلال٢-٣ ايام عمل
Zone 1 منطقه 1


Within 3-4 business days
Zone 2 - Zone 3 خلال ٣-٤ ايام عمل
منطقه 2 - منطقه 3


Within 4-5 business days خلال ٤-٥ ايام عمل
Zone 4 منطقة 4


Within 5-7 business days خلال ٥- ٧ ايام عمل
Zone 5 - Zone 6 منطقة 5 - منطقة 6 ',
                'link_en' => 'Shipping-&-Delivery',
                'link_ar' => 'الشحن-الاستلام',
                'status' => 1,
                'index' => 1,
            ],
        ];

        foreach ($pages as $page) {
            Page::create($page);
        }
    }
}
