<?php

namespace Database\Factories;

use App\Helpers\Media;
use App\Models\Attribute;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Product>
 */
class ProductFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
       

        return [
            'name_ar' => fake()->words(2, true),
            'name_en' =>  fake()->words(2, true),
            'code' => fake()->unique()->word,
            'category_id' => null,
            'brand_id' => Brand::inRandomOrder()->first()->id ?? null,
            'order' => fake()->numberBetween(1, 100),
            'price' => fake()->randomFloat(2, 100, 1000),
            'quantity' => fake()->numberBetween(0, 100),
            'short_text_ar' => fake('ar_SA')->sentence(),
            'short_text_en' => fake()->sentence(),
            'text_ar' => fake('ar_SA')->realText(),
            'text_en' => fake()->realText(),
            'alt_main_image' => fake()->word(),
            'alt_second_image' => fake()->word(),
            'status' => fake()->boolean(80),
            'featured' => fake()->boolean(50),
            'home' => fake()->boolean(20),
            'link_ar' => Str::slug(fake()->unique()->words(2, true)),
            'link_en' => Str::slug(fake()->unique()->words(2, true)),
            'meta_title_ar' => fake()->title(),
            'meta_title_en' => fake()->title(),
            'meta_description_ar' => fake()->sentence(),
            'meta_description_en' =>  fake()->sentence(),
            'index' => fake()->boolean(70),
        ];
    }


}
