<?php

namespace Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Partner>
 */
class PartnerFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name_en' => fake()->company(),
            'name_ar' => fake()->company(),
            'logo' => null,
            'short_desc_en' => fake()->sentence(),
            'short_desc_ar' => fake()->sentence(),
            'description_en' => fake()->paragraph(),
            'description_ar' => fake()->paragraph(),
            'slug_en' => fake()->slug(),
            'slug_ar' => fake()->slug(),
            'website' => fake()->url(),
            'status' => true,
        ];
    }
}
