<?php

namespace App\Services\ProductServices;


use Illuminate\Support\Facades\DB;

class VariantService
{
    public function store(array $data, $product)
    {

        DB::beginTransaction();
        try {
            $variant = $product->variants()->create([
                'additional_price' => $data['additional_price'] ?? 0,
                'stock' => $data['stock']
            ]);

            foreach ($data['value_ids'] as $valueId) {
                $variant->values()->create([
                    'value_id' => $valueId
                ]);
            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();

            throw $e;
        }
    }

    public function update($data, $product, $variant)
    {

        DB::beginTransaction();
        try {
            $variant->update([
                'additional_price' => $data['additional_price'],
                'stock' => $data['stock'],
            ]);

            $variant->values()->delete();
            
            foreach ($data['value_ids'] as $valueId) {
                $variant->values()->create([
                    'value_id' => $valueId
                ]);
            }

            DB::commit();
            return true;
        } catch (\Exception $e) {
            DB::rollBack();

            throw $e;
        }
    }
}
