<?php

namespace App\Providers;

use App\Models\About;
use App\Models\Admin\SiteAddress;
use App\Models\Brand;
use App\Models\Category;
use App\Models\Menu;
use App\Models\Page;
use App\Models\PaymentMethod;
use App\Models\Product;
use App\Models\SampleRequest;
use App\Models\Slider;
use App\Models\WishList;
use App\Traits\Carts\CartTrait;
use App\Traits\Carts\GuestCartTrait;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;

use Illuminate\Support\Facades\View;
use Mcamara\LaravelLocalization\Facades\LaravelLocalization;

class AppServiceProvider extends ServiceProvider
{
    use CartTrait, GuestCartTrait;
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register(): void
    {
        //
    }


    public function boot()
    {

        Model::preventLazyLoading(! $this->app->isProduction());
        // Model::shouldBeStrict(! app()->isProduction()); 


        Schema::defaultStringLength(191);

        view()->composer('*', function ($view) {

            $lang = LaravelLocalization::getCurrentLocale();

            $cart = auth()->check() ? $this->getCart() : $this->getGuestCart();

            $cartCount =   $cart  ? $cart->items->count() : 0;

            $cartProductIds = $cart->items()->pluck('product_id');

            $categoryIds = Product::whereIn('id', $cartProductIds)->pluck('category_id');

            $related_cart_products  = Product::with(['variants.images', 'variants.values.value.attribute'])
                ->whereIn('category_id', $categoryIds)
                ->whereNotIn('id', $cartProductIds)
                ->inRandomOrder()
                ->active()
                ->limit(6)
                ->get();




            if (auth()->check()) {
                $wishListCount = WishList::where('user_id', auth()->user()->id)->count();
            } else {
                // Ensure session ID exists and get wishlist count for guest users
                $session_id = $this->getOrGenerateGuestCartSession();
                $wishListCount = $session_id ? WishList::where('session_id', $session_id)->count() : 0;
            }

            // SampleRequest //
            if (auth()->check()) {
                $sampleRequestCount = SampleRequest::where('user_id', auth()->user()->id)->count();
            } else {
                // Ensure session ID exists and get wishlist count for guest users
                $session_id = session()->getId();
                $sampleRequestCount = $session_id ? SampleRequest::where('session_id', $session_id)->count() : 0;
            }

            $topHeaders = Slider::active()->whereType('topHeader')->get();

            $menus = Menu::main()->active()->orderBy('order', 'asc')->get();

            $parent_categories = Category::with(['subcategories.products', 'products'])
                ->whereNull('parent_id')
                ->active()
                ->take(5)->get();


            $pages = Page::active()->get();



            $payment_methods = PaymentMethod::where('status', 1)->get();


            View::share('lang', $lang);
            View::share('cart', $cart);
            View::share('related_cart_products', $related_cart_products);
            View::share('menus', $menus);
            View::share('parent_categories', $parent_categories);
            View::share('payment_methods', $payment_methods);

            View::share('topHeaders', $topHeaders);
            View::share('cartCount', $cartCount);
            View::share('wishListCount', $wishListCount);
            View::share('sampleRequestCount', $sampleRequestCount);
            View::share('pages', $pages);
        });
    }
}
