<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;
use DB;


class Slider extends Model
{
	protected $table='sliders';
    private $lang ;

    protected $fillable = [
        'title_ar',
        'title_en',
        'text_ar',
        'text_en',
        'video_link',
        'link',
        'image',
        'order',
        'type',
        'status',
    ];

public const TYPES = ['home','banner','topHeader','pop'];


    public function getTitleAttribute(){
        return $this->{'title_'.Helper::getLang()} ;
    }

    public function getTextAttribute(){
        return $this->{'text_'.Helper::getLang()} ;
    }

    public function getImagePathAttribute(){
        return $this->image ?  Helper::uploadedImagesPath('sliders',$this->image)   : Helper::noImage() ;
    }


    public function scopeActive($query){
        return  $query->whereStatus(true);
      }

      public function scopeUnactive($query){
        return   $query->whereStatus(0);
      }




}
