<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    //
    protected $table = 'setting' ;

    protected $fillable = ['key', 'value', 'lang'];

    public const IMAGE_KEYS = ['logo' ,'footer_logo', 'favicon'] ;


    // Accessor for the image path
    public function getValueAttribute($value)
    {
        if (in_array($this->key, self::IMAGE_KEYS)) {
            return $value ? asset('storage/configrations/' . $value) : Helper::noImage() ;
        }
    
        return $value;
    }
    



}
