<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Cart extends Model
{
    
    protected $table = 'carts';

    protected $fillable = ['user_id', 'session_id', 'coupon_id'];



    public function coupon()
    {
        return $this->belongsTo(Coupon::class);
    }


    public function items()
    {
        return $this->hasMany(CartItems::class);
    }


    public function getTotalPriceAttribute()
    {
        $total_price =  $this->items->sum(function ($item) {
           return $item->product->getEffectivePrice($item->product_variant_id) * $item->quantity;
        });

        return  round($total_price);
    }

    public function getTotalDiscountsAttribute()
    {
        $total_amount = $this->items->sum(function($item){
            return $item->product->getDiscountAmount($item->product_variant_id);
        });

        return round($total_amount);
    }
}
