<?php

namespace App\Models;

use App\Helpers\Helper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AboutStruc extends Model
{
    use HasFactory;
    protected $table = 'about_strucs';
   
    protected $fillable = [
        'name_ar',
        'name_en',
        'text_ar',
        'text_en',
        'status',
        'parent_id',
        'image',
        'order',
    ];

    public function children(){
        return $this->hasMany(self::class,'parent_id','id');
    }

    public function parent(){
        return $this->belongsTo(self::class,'parent_id','id');
    }

    public function getNameAttribute(){
        return $this->{'name_'.Helper::getLang()} ;
    }
    public function getTextAttribute(){
        return $this->{'text_'.Helper::getLang()} ;
    }
    public function getParentNameAttribute(){
        return  $this->parent?->name ;
    }
    public function getParentTextAttribute(){
        return  $this->parent?->text ;
    }


    public function getActiveAttribute(){
        return   $this->status ? __('home.yes') : __( 'home.no') ;
     }

     public function scopeActive($query){
        return  $query->whereStatus(1);
      }

    public function scopeUnactive($query){
        return   $query->whereStatus(0);
      }

    public function getImagePathAttribute(){
        return $this->image ?  Helper::uploadedImagesPath('aboutStrucs',$this->image) : Helper::noImage() ;
    }


}
