<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreBranchRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name_en' => 'nullable|string|max:255',
            'name_ar' => 'nullable|string|max:255',
            'address_en' => 'nullable|string|max:255',
            'address_ar' => 'nullable|string|max:255',
            'governorate_id' => 'nullable|exists:governorates,id',
            'phone' => 'nullable|numeric|min:0',
            'phone2' => 'nullable|numeric|min:0',
            'telephone' => 'nullable|numeric|min:0',
            'map_url' => 'nullable|string|max:255',
            'status' => 'boolean',
        ];
    }
}
