<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class ProductRequest extends FormRequest
{
    public function authorize()
    {
        return true; // Set to false if authorization is required.
    }

    public function rules()
    {

        return [
            'name_ar' => 'required|string|max:255',
            'name_en' => 'required|string|max:255',
            'code' => 'nullable|string|max:10|unique:products,code,' . $this->route('product'),
            'category_id' => 'nullable|exists:categories,id',
            'brand_id' => 'nullable|exists:brands,id',
            'order' => 'required|integer',
            'price' => ['nullable'],
            'quantity' => ['nullable','integer'],
            'text_ar' => 'nullable|string',
            'text_en' => 'nullable|string',
            'short_text_ar' => 'nullable|string',
            'short_text_en' => 'nullable|string',
            'main_image' => ['nullable','image','mimes:webp','max:1024'],
            'second_image' => ['nullable','image','mimes:webp','max:1024'],
            'icon' => 'nullable|string|max:255',
            'status' => 'nullable|boolean', // Validate as 0 or 1
            'link_ar' => 'required|string|max:255|unique:products,link_ar,' . $this->route('product'),
            'link_en' => 'required|string|max:255|unique:products,link_en,' . $this->route('product'),
            'meta_title_ar' => 'nullable|string|max:255',
            'meta_title_en' => 'nullable|string|max:255',
            'meta_description_ar' => 'nullable|string',
            'meta_description_en' => 'nullable|string',
            'index' => 'nullable|boolean',
            'home' => 'nullable|boolean',
            'featured' => 'nullable|boolean',
            'attributes' => 'nullable|array|min:1',
            'attributes.*' => 'required|exists:attributes,id',

        ];
    }
}
