<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\Media;
use App\Http\Controllers\Controller;
use App\Http\Requests\SliderRequest;
use App\Models\Slider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
class SliderController extends Controller
{


    public function __construct(){
        $this->middleware(['permission:sliders']);
    }

    public function index()
    {
        //
        $data['sliders'] = Slider::orderBy('order')->get();
        return view('admin.sliders.home-sliders.sliders', $data);
    }


    public function create()
    {
        return view('admin.sliders.home-sliders.addSlider');
    }


    public function store(SliderRequest $request)
    {
        DB::beginTransaction();
        try {

            $data = $request->validated();

            if ($request->hasFile('image')) {
                $data['image'] = Media::uploadAndAttachImage($request->file('image'), 'sliders');
            }

            Slider::create($data);

            DB::commit();

            return redirect()->route('sliders.index')->with('success',trans('home.your_item_added_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors($e->getMessage());
        }
    }




    public function edit(Slider $slider)
    {
            return view('admin.sliders.home-sliders.editSlider',compact('slider'));
    }


    public function update(SliderRequest $request, Slider $slider)
    {
        DB::beginTransaction();
        try {
            $data = $request->validated();

            $data['status'] = $data['status'] ?? 0; 

            if ($request->hasFile('image')) {
                if ($slider->image) {
                    Media::removeFile('sliders', $slider->image);
                }
                $data['image'] = Media::uploadAndAttachImage($request->file('image'), 'sliders');
            }

            $slider->update($data);

            DB::commit();

            return redirect()->back()->with('success', trans('home.your_item_updated_successfully'));
        } catch (\Exception $e) {
            DB::rollBack();
            return redirect()->back()->withErrors($e->getMessage());
        }
    }


    public function destroy(Request $request)
    {
        $selectedIds = $request->input('id');
       

        $sliders = Slider::whereIn('id', $selectedIds)->get();

        DB::beginTransaction();
        try {
            foreach ($sliders as $slider) {
                // Delete associated image if it exists
                if ($slider->image) {
                    
                    Media::removeFile('sliders', $slider->image);
                }
             
            }
            Slider::whereIn('id', $selectedIds)->delete();

            DB::commit();

            return response()->json(['success' => true, 'message' => __('home.your_items_deleted_successfully')]);
        } catch (\Exception $e) {

            DB::rollBack();
            return response()->json(['error' => true, 'message' => __('home.an error has occurred. ' . $e->getMessage())]);
        }
    }

}
