<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\OrderShipmentStatus;
use App\Models\OrderStatus;
use Illuminate\Http\Request;

class OrderController extends Controller
{
    public function index()
    {
        $orders = Order::with([
            'user',
            'status',
            'payment.paymentMethod',
            'address.governorate',
            'address.country',
            'items.product',
        ])
        ->orderBy('created_at', 'desc')
        ->get();
    
        return view('admin.orders.orders', compact('orders'));
    }

    public function edit($id)
    {
        $data['order'] = Order::with(['items.product', 'user', 'address', 'payment'])->findOrFail($id);
      
        $data['order_statuses'] = OrderStatus::all();
      
        $data['order_shipment_statuses'] = OrderShipmentStatus::all();

       
        return view('admin.orders.edit', $data);
    }
}
