<?php

namespace App\Http\Controllers\Admin;

use App\Helpers\SaveImageTo3Path;
use App\Http\Controllers\Controller;
use App\Http\Requests\BrandsRequest;
use App\Models\Brand;

use Illuminate\Http\Request;

class BrandController extends Controller
{


    public function __construct()
    {
        $this->middleware(['permission:brands']);
    }

    public function index()
    {
        $data['brands'] = Brand::all();

        return view('admin.brands.brands', $data);
    }


    public function create()
    {
        return view('admin.brands.addBrand');
    }


    public function store(BrandsRequest $request)
    {
        $data = $request->validated();

        $data['link_en'] = preg_replace('/[\/\\\ ]/', '-', $data->name_en);

        $data['link_ar'] = preg_replace('/[\/\\\ ]/', '-', $data->name_ar);

        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'), true);
            $fileName = $saveImage->saveImages('brands');
            $data['image'] = $fileName;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'), true);
            $fileName = $saveImage->saveImages('brands');
            $data['icon'] = $fileName;
        }

        Brand::create($data);

        return redirect()->bsck()->with('success', trans('home.your_item_added_successfully'));
    }


    public function edit($id)
    {
        $brand = Brand::find($id);
        if ($brand) {
            return view('admin.brands.editBrand', compact('brand'));
        } else {
            abort('404');
        }
    }

    public function update(BrandsRequest $request, $id)
    {
        $brand = Brand::find($id);

        $data = $request->validated();



        if (!isset($data['status'])) {
            $data['status'] = 0;
        }
        if ($request->hasFile("image")) {
            $saveImage = new SaveImageTo3Path(request()->file('image'), true);
            $fileName = $saveImage->saveImages('brands');
            SaveImageTo3Path::deleteImage($brand->image, 'brands');
            $data['image'] = $fileName;
        }

        if ($request->hasFile("icon")) {
            $saveImage = new SaveImageTo3Path(request()->file('icon'), true);
            $fileName = $saveImage->saveImages('brands');
            SaveImageTo3Path::deleteImage($brand->icon, 'brands');
            $data['icon'] = $fileName;
        }
        $brand->update($data);

        return redirect()->back()->with('success', trans('home.your_item_updated_successfully'));
    }

    public function destroy($id)
    {
        if (request('id')) {
            request()->validate([
                'id' => 'array|min:1|',
                'id.*' => 'exists:brands,id'
            ]);
            $ids =  request('id');
            $delete = Brand::whereIn('id', $ids)->delete();
            // check if comming from ajax
            if (request()->ajax()) {
                // check is is deleted or has any exception
                if (!$delete) {
                    return response()->json(['message' => $delete ?? __('home.an messages.error entering data')], 422);
                }
                return response()->json(['message' => trans('home.your_items_deleted_successfully')]);
            }
            if (!$delete) {
                return redirect()->back()->withErrors($delete ?? __('home.an messages.error entering data'));
            }
            return redirect()->back()->with('success', trans('home.your_items_deleted_successfully'));
        } elseif ($brand = Brand::find($id)) {
            // check is is deleted or has any exception
            $delete = $brand->delete();
            if (request()->ajax()) {
                // check is is deleted or has any exception
                if ($delete != 1) {
                    return response()->json(['message' => $delete ?? __('home.an message.error entering data')], 422);
                }
                return response()->json(['message' => trans('home.your_item_deleted_successfully')]);
            }
            if ($delete != 1) {
                return redirect()->back()->withErrors($delete ?? __('home.an messages.error entering data'));
            }
            return redirect()->back()->with('success', trans('home.your_item_deleted_successfully'));
        }
    }
}
