<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php
            echo isset($title) ? $title : NULL;
            ?>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="box box-primary">

            <div class="box-header with-border">
                <h3 class="box-title ">Show / Edit  Phones Branches</h3>
            </div>
            <!-- /.box-header -->
            <div class="row">
                <!-- /.box-header -->
                <div class="adminform">
                    <div class="col-xs-12 deleteResult"></div>
                    <table id="all_data"
                           class="table table_for_data table-striped table-bordered dt-responsive nowrap tableData"
                           cellspacing="0" width="100%">
                        <thead>
                        <tr>
                            <th>Id</th>
                            <th>Phone</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php
                        if (isset($branchPhones) && is_array($branchPhones)) {
                            foreach ($branchPhones as $key => $data) {
                                echo '<tr id="row' . $data['id'] . '">
                                                                    <td>' . $data['id'] . '</td>
                                                                    <td>' . $data['phone'] . '</td>
                                                                 ';

                                echo '</td>
                                                                    <td>
                                                                        <ul class="actions">
                                                                         <li><a href="" data-toggle="modal" data-id="' . $data['id'] . '" data-target="#deleteModal" class="deleteIcon" title="Delete"><i class="fa fa-trash" aria-hidden="true"></i>  </a></li>
                                                                        </ul>
                                                                    </td>
                                                                  </tr>';
                            }
                        } else {
                            echo '<tr><td colspan="4">No Data Found</td></tr>';
                        }
                        ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="row">
                <div class="col-sm-6">
                    <form method="post" enctype="multipart/form-data">

                        <!-- /.box-body -->
                        <div class="form-group">
                            <div class="table-responsive">
                                <table class="table table-bordered" id="dynamic_field">
                                    <tr>
                                        <td><input type="text" name="phones[]" placeholder="Enter your Other Phone"
                                                   class="form-control name_list"/></td>
                                        <td>
                                            <button type="button" name="add" id="add" class="btn btn-success">Add More
                                                Phone
                                            </button>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                        <div class="box-footer">
                            <button type="submit" name="add" class="btn btn-primary">add</button>
                        </div>

                    </form>
                </div>
            </div>
        </div>
    </section><!-- /.content -->
</div><!-- /.content-wrapper -->


<!-- Start Delete Modal -->
<div class="modal fade" id="deleteModal" role="dialog">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title">Confirm delete Your Data</h4>
            </div>
            <div class="modal-body">
                <div id="deleteResult"></div>
                <p>Are You Sure ? </p>
                <input type="submit" class="btn btn-primary del" name="delete" value="Delete"/>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>
<!--End Delete Modal-->

<script>
    $(document).ready(function () {
        var i = 1;
        $('#add').click(function () {
            i++;
            $('#dynamic_field').append('<tr id="row' + i + '"><td><input type="text" name="phones[]" placeholder="Enter Your Other Phone" class="form-control name_list" /></td><td><button type="button" name="remove" id="' + i + '" class="btn btn-danger btn_remove">X</button></td></tr>');
        });
        $(document).on('click', '.btn_remove', function () {
            var button_id = $(this).attr("id");
            $('#row' + button_id + '').remove();
        });
        $('#all_data').DataTable();


        // start delete
        $(".table_for_data").on('click', '.deleteIcon', function () {
            $("#deleteResult").html("");
            var myId = $(this).attr("data-id");
            var myaction = "deleteData";
            var allData = {"action": myaction, "id": myId};
            $(".del").click(function () {
                $.ajax({
                    url: "<?php echo BASE_URL . 'branches/delete_branch_phones' ?>",
                    type: "POST",
                    data: allData,
                    beforeSend: function () {
                    },
                    statusCode: {
                        404: function () {
                            alert("page not found");
                        },
                    },
                    success: function (valdata) {
                        var da = jQuery.parseJSON(valdata);
                        if (da['status'] == "success") {
                            $("#deleteResult").html('<div class="alert alert-success" role="alert"><strong>Success </strong> Data Deleted Successfuly </div>');
                            $('#deleteModal').modal('hide')
                            $("#row" + myId).fadeOut(1000);
                        } else {
                            $("#deleteResult").html('<div class="alert alert-danger" role="alert"><strong> Error ! </strong> Error Deleting  Your Data </div>');
                        }
                    }
                });
                return false;
            });
        });
        // end delete


    });
</script>
