<?php

class Offer extends Controller
{


    public function add()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/


        //start Add Anew data
        if (isset($_POST['add'])) {

            // preparing validation array
            $validationArray = array(

                "id_category" => array(
                    "value" => $this->loadSecurity($_POST['id_category'])->clear(),
                    "errorName" => "Main Category",
                    "rules" => "required|number"
                ),

                "title" => array(
                    "value" => $this->loadSecurity($_POST['title'])->clear(),
                    "errorName" => "Product Title",
                    "rules" => "required|min-length[3]"
                ),
                "slug" => array(
                    "value" => $this->loadSecurity($_POST['slug'])->clear(),
                    "errorName" => "Product Slug",
                    "rules" => "required|min-length[3]"
                ),
                "description" => array(
                    "value" => $_POST['description'],
                    "errorName" => "Description",
                    "rules" => "min-length[5]"
                ),
                "title_ar" => array(
                    "value" => $this->loadSecurity($_POST['title_ar'])->clear(),
                    "errorName" => "عنوان المنتج",
                    "rules" => "required|min-length[3]"
                ),
                "slug_ar" => array(
                    "value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
                    "errorName" => "مختصر المنتج",
                    "rules" => "required|min-length[3]"
                ),
                "description_ar" => array(
                    "value" => $_POST['description_ar'],
                    "errorName" => "الوصف",
                    "rules" => "min-length[5]"
                ),
                "status" => array(
                    "value" => $this->loadSecurity($_POST['status'])->clear(),
                    "errorName" => "Status",
                    "rules" => "required|number"
                ),


            );
            // load validation classs and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                // upload main image
                $upload = $this->loadUpload("image")->do_upload();
                //if there is no errors
                if (!array_key_exists('uploadError', $upload)) {
                    $productDataModel['id_category'] = $dataValid['success']['id_category'];
                    $productDataModel['image'] = $upload['uploaded'][0];
                    $productDataModel['status'] = $dataValid['success']['status'];
                    $productDataModel['created'] = time();
                    $productDataModel['created_by'] = $user_id;
                    $productDataModel['last_updated_by'] = $user_id;

                    // add data
                    $add = $this->loadModel("OfferModel", $productDataModel)->add();
                    if (FALSE !== $add) {
                        // add data en
                        $offerEnDataModel['id_offer'] = $add;
                        $offerEnDataModel['title'] = $dataValid['success']['title'];
                        $offerEnDataModel['slug'] = $dataValid['success']['slug'];
                        $offerEnDataModel['description'] = $dataValid['success']['description'];
                        $offerEnDataModel['status'] = $dataValid['success']['status'];
                        $offerEnDataModel['created'] = time();
                        $this->loadModel("OfferEnModel", $offerEnDataModel)->add();
                        // add data ar
                        $offerArDataModel['id_offer'] = $add;
                        $offerArDataModel['title'] = $dataValid['success']['title_ar'];
                        $offerArDataModel['slug'] = $dataValid['success']['slug_ar'];
                        $offerArDataModel['description'] = $dataValid['success']['description_ar'];
                        $offerArDataModel['status'] = $dataValid['success']['status'];
                        $offerArDataModel['created'] = time();
                        $this->loadModel("OfferArModel", $offerArDataModel)->add();

                        // start add offer images if found
                        $albumImagesData = $this->loadUpload("album", FALSE)->do_upload();
                        // check if there is error on image
                        if (!array_key_exists("uploadError", $albumImagesData)) {
                            if ($albumImagesData['uploaded'][0] != NULL) {
                                foreach ($albumImagesData['uploaded'] as $value) {
                                    $albumImages['id_offer'] = $add;
                                    $albumImages['image'] = $value;
                                    $albumImages['created'] = time();
                                    // load Model To Add Gallery Name
                                    $addImages = $this->loadModel("OfferImagesModel", $albumImages)->add();
                                }

                            }
                        }

                        $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
                        header("Refresh: 2");

                    } else {
                        $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Your Data Please Try Again2</div>';
                    }
                } else {
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Can Not Upload Main Image (Max Size : 5MB & Allowed Extensions : png - jpg - jpeg)</div>';
                }
            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
            }
        }


        // get categories
        $dataView['allCategories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE  `status` =? AND `deleted` =?", array(1, 1));

        if (is_array($dataView['allCategories'])) {
            foreach ($dataView['allCategories'] as $key => $data) {
                $dataView['allCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $data['id']);
                $dataView['allCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $data['id']);
            }
        }

        $dataView['title'] = "Add Product";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        //$TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH."offer_add";
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offer_add";

        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function getAll()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        $dataView['offers'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE  `deleted` =?", array( 1));
        if (is_array($dataView['offers'])) {
            foreach ($dataView['offers'] as $key => $value) {
                $dataView['offersCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersDataEn'][$key] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $value['id']);
                $dataView['offersDataAr'][$key] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $value['id']);
            }
        }
        //var_dump($dataView['latestPrice']);
        //get product latest price
        $dataView['title'] = "Show All product";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offers_getall";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }
    public function today_offers()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        $todayDate = date('Y/m/d');
        $dataView['offers'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `created` >= ? AND `deleted` =?", array(strtotime($todayDate), 1));
        if (is_array($dataView['offers'])) {
            foreach ($dataView['offers'] as $key => $value) {
                $dataView['offersCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersDataEn'][$key] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $value['id']);
                $dataView['offersDataAr'][$key] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $value['id']);
            }
        }
        //var_dump($dataView['latestPrice']);
        //get product latest price
        $dataView['title'] = "Show Today product";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offers_today_getall";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function month_offers()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        $monthDate = date('Y/m/01');
        $dataView['offers'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `created` >= ? AND `deleted` =?", array(strtotime($monthDate), 1));
        if (is_array($dataView['offers'])) {
            foreach ($dataView['offers'] as $key => $value) {
                $dataView['offersCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id_category']);
                $dataView['offersDataEn'][$key] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $value['id']);
                $dataView['offersDataAr'][$key] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $value['id']);

            }
        }
        $dataView['title'] = "Show Month product";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offers_month_getall";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function offers_report()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/

        if (isset($_POST['search'])) {

            // preparing validation array
            $validationArray = array(
                "date_from" => array(
                    "value" => $this->loadSecurity($_POST['dateFrom'])->clear(),
                    "errorName" => "Date From",
                    "rules" => "required"
                ),
                "date_to" => array(
                    "value" => $this->loadSecurity($_POST['dateTo'])->clear(),
                    "errorName" => "Date To",
                    "rules" => "required"
                ),
            );
            // load validation classs and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                $dataView['offers'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `created` BETWEEN ? AND ? AND `deleted` =?", array(strtotime($dataValid['success']['date_from']), strtotime($dataValid['success']['date_to']), 1));
                if (is_array($dataView['offers'])) {
                    foreach ($dataView['offers'] as $key => $value) {
                        $dataView['offersCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $value['id_category']);
                        $dataView['offersCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id_category']);
                        $dataView['offersDataEn'][$key] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $value['id']);
                        $dataView['offersDataAr'][$key] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $value['id']);

                    }
                }
            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
            }
        }

        $dataView['title'] = "Make Products Report";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offers_report_make";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function edit_selected()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        // get id from url
        $id = (int)$this->loadRoute()->getSegment(2);
        if ($id == 0) {
            $this->redirect("Errors", "index");
            exit();
        }
        // get offer data
        $dataView['offer'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
        if (!is_array($dataView['offer'])) {
            $this->redirect("Errors", "index");
            exit();
        }
        $dataView['offer'] = array_shift($dataView['offer']);
        // offer lang data
        $dataView['offerEnData'] = $this->loadModel("OfferEnModel")->retriveDataById("id_offer", $id);
        $dataView['offerArData'] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $id);
        // get offer images
        $dataView['offerImages'] = $this->loadModel("OfferImagesModel")->retrieveAllData("WHERE `id_offer` =? AND `status` =? AND `deleted` = ?", array($id, 1, 1));
        // get main category sub categories
        $dataView['subCategories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `id_category` =? AND `status` =? AND `deleted` = ?", array($dataView['offer']['id_category'], 1, 1));
        if (is_array($dataView['subCategories'])) {
            foreach ($dataView['subCategories'] as $key => $value) {
                $dataView['subCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id']);
                $dataView['subCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $value['id']);
            }
        }


        // get categories
        $dataView['allCategories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE  `status` =? AND `deleted` =?", array(1, 1));

        if (is_array($dataView['allCategories'])) {
            foreach ($dataView['allCategories'] as $key => $data) {
                $dataView['allCategoriesEn'][$key] = $this->loadModel("CategoryEnModel")->retriveDataById("id_category", $data['id']);
                $dataView['allCategoriesAr'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $data['id']);
            }
        }

        if (isset($_POST['edit'])) {

            // preparing validation array
            $validationArray = array(

                "id_category" => array(
                    "value" => $this->loadSecurity($_POST['id_category'])->clear(),
                    "errorName" => "Main Category",
                    "rules" => "required|number"
                ),
                "title" => array(
                    "value" => $this->loadSecurity($_POST['title'])->clear(),
                    "errorName" => "Product Title",
                    "rules" => "required|min-length[3]"
                ),
                "slug" => array(
                    "value" => $this->loadSecurity($_POST['slug'])->clear(),
                    "errorName" => "Product Slug",
                    "rules" => "required|min-length[3]"
                ),
                "description" => array(
                    "value" => $_POST['description'],
                    "errorName" => "Description",
                    "rules" => "min-length[5]"
                ),
                "title_ar" => array(
                    "value" => $this->loadSecurity($_POST['title_ar'])->clear(),
                    "errorName" => "عنوان المنتج",
                    "rules" => "required|min-length[3]"
                ),
                "slug_ar" => array(
                    "value" => $this->loadSecurity($_POST['slug_ar'])->clear(),
                    "errorName" => "مختصر المنتج",
                    "rules" => "required|min-length[3]"
                ),
                "description_ar" => array(
                    "value" => $_POST['description_ar'],
                    "errorName" => "الوصف",
                    "rules" => "min-length[5]"
                ),
                "status" => array(
                    "value" => $this->loadSecurity($_POST['status'])->clear(),
                    "errorName" => "Status",
                    "rules" => "required|number"
                ),


            );
            // load validation classs and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                $productDataModel['id_category'] = $dataValid['success']['id_category'];
                $productDataModel['status'] = $dataValid['success']['status'];
                $productDataModel['last_updated_by'] = $user_id;

                // update data
                $update = $this->loadModel("OfferModel", $productDataModel)->updateData("id", $id);
                if (FALSE !== $update) {
                    // update data en
                    $offerEnDataModel['title'] = $dataValid['success']['title'];
                    $offerEnDataModel['slug'] = $dataValid['success']['slug'];
                    $offerEnDataModel['description'] = $dataValid['success']['description'];
                    $offerEnDataModel['status'] = $dataValid['success']['status'];
                    $this->loadModel("OfferEnModel", $offerEnDataModel)->updateData("id_offer", $id);
                    // add data ar
                    $offerArDataModel['title'] = $dataValid['success']['title_ar'];
                    $offerArDataModel['slug'] = $dataValid['success']['slug_ar'];
                    $offerArDataModel['description'] = $dataValid['success']['description_ar'];
                    $offerArDataModel['status'] = $dataValid['success']['status'];
                    $offerArDataModel['created'] = time();
                    $this->loadModel("OfferArModel", $offerArDataModel)->updateData("id_offer", $id);

                    $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
                    header("Refresh: 2");

                } else {
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data Please Try Again</div>';
                }

            } else {
                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>' . $dataValid . '</div>';
            }
        }

        // set page title
        $dataView['title'] = "Edit Product Information";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offer_edit_selected";


        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }


    public function edit_images()
    {
        /******** start header code ********/
        if (FALSE !== $this->loadHelper("UserHelper")->check_user_login()) {
            // get user id from session
            $user_id = $this->loadSession()->getSession("user_id");
            // get user data for header
            $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id", $user_id);
            if ($dataView['userData'] == NULL) {
                $this->redirect("Errors", "index");
                exit();
            }
        } else {
            $this->redirect("admin", "login");
        }

        /******* end header code *******/
        // get id from url
        $id = (int)$this->loadRoute()->getSegment(2);
        if ($id == 0) {
            $this->redirect("Errors", "index");
            exit();
        }
        // get trip data
        $dataView['offer'] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `id` =? AND `deleted` =?", array($id, 1));
        if (!is_array($dataView['offer'])) {
            $this->redirect("Errors", "index");
            exit();
        }
        $dataView['offer'] = array_shift($dataView['offer']);
        // get offer summery
        // get offer images
        $dataView['offerImages'] = $this->loadModel("OfferImagesModel")->retrieveAllData("WHERE `id_offer` =? AND `status` =? AND `deleted` = ?", array($id, 1, 1));

        // set page title
        $dataView['title'] = "Edit Product Images";
        // global Template Config
        global $TEMPLATE_BACK_END;
        // set content
        $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "offer" . DIRECTORY_SEPARATOR . "offer_images_edit";
        // load template
        $this->loadTemplate($TEMPLATE_BACK_END, $dataView)->render();
    }

    public function offer_add_more_images()
    {
        $id = (int)$_POST['id_offer'];
        if ($id == 0) {
            echo $this->loadAjax()->DataToJson(array("status" => "faild"));
            exit;
        }
        // upload images
        $upload = $this->loadUpload("images")->do_upload();
        $counter = 0;
        foreach ($upload['uploaded'] as $value) {
            //preparing data to be sent to model
            $albumImagesData['id_offer'] = $id;
            $albumImagesData['created'] = time();
            $albumImagesData['image'] = $value;
            // load Model To Add Images Name
            if ($this->loadModel("OfferImagesModel", $albumImagesData)->add()) {
                $counter++;
            }
        }
        if ($counter == 0) {
            echo $this->loadAjax()->DataToJson(array("status" => "faild"));
            exit;
        } else if ($counter < count($upload['uploaded'])) {
            echo $this->loadAjax()->DataToJson(array("status" => "Somefaild"));
            exit;
        } else {
            echo $this->loadAjax()->DataToJson(array("status" => "success"));
            exit;
        }
    }

    public function delete_offer_images()
    {
        if (isset($_POST['action'], $_POST['imageId']) && $_POST['action'] == "deleteImage") {

            // get image id
            $image_id = (int)$_POST['imageId'];

            if ($image_id == 0) {
                echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                exit;
            } else {

                if (false !== $this->loadModel("OfferImagesModel", array("deleted" => 2))->updateData("id", $image_id)) {
                    echo $this->loadAjax()->DataToJson(array("status" => "success"));
                    exit;
                } else {
                    echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                    exit;
                }
            }
        }
    }

    public function update_image()
    {
        //get id
        $id = (int)$_POST['field_id'];
        if ($id == 0) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid"));
            exit;
        } else {
            $upload = $this->loadUpload("image_name")->do_upload();
            // check if there is error on image
            if (array_key_exists("uploadError", $upload)) {
                echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                exit;

            } else {
                $dataModel['image'] = $upload['uploaded'][0];
                $dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
                if (false !== $this->loadModel("OfferModel", $dataModel)->updateData("id", $id)) {
                    echo $this->loadAjax()->DataToJson(array("status" => "success", "newImage" => $dataModel['image']));
                    exit;
                } else {
                    echo $this->loadAjax()->DataToJson(array("status" => "falid"));
                    exit;
                }
            }
        }
    }

    public function updateStatus()
    {
        if (isset($_POST['action'], $_POST['id'], $_POST['status']) && $_POST['action'] == "updateStatus") {
            // get User id
            $id = (int)$_POST['id'];
            if ($id == 0) {
                $this->redirect("Errors", "index");
                exit;
            } else {
                // get current status
                $currentStatus = $_POST['status'];
                // if current status = on set it off
                if ($currentStatus == "on") {
                    $setStatus = 2;
                } else {
                    $setStatus = 1;
                }
                $dataModel['status'] = $setStatus;
                $dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
                if (false !== $this->loadModel("OfferModel", $dataModel)->updateData("id", $id)) {
                    echo $this->loadAjax()->DataToJson(array("status" => "success"));
                    exit;
                } else {
                    echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                    exit;
                }
            }
        }
    }

    public function delete()
    {
        if (isset($_POST['action'], $_POST['id']) && $_POST['action'] == "deleteData") {
            $id = (int)$_POST['id'];
            if ($id == 0) {
                $this->redirect("Errors", "index");
                exit;
            } else {
                if (FALSE !== $this->loadModel("OfferModel", array("deleted" => 2))->updateData("id", $id)) {
                    echo $this->loadAjax()->DataToJson(array("status" => "success"));
                    exit;
                } else {
                    echo $this->loadAjax()->DataToJson(array("status" => "faild"));
                    exit;
                }
            }
        }
    }

    public function upload_offer_image()
    {

        $upload = $this->loadUpload("offerImage")->do_upload();
        // check if there is error on image
        if (array_key_exists("uploadError", $upload)) {
            echo $this->loadAjax()->DataToJson(array("status" => "falid"));
            exit;

        } else {
            $dataModel['image'] = $upload['uploaded'][0];
            echo $this->loadAjax()->DataToJson(array("status" => "success", "newImageUrl" => UPLOAD_LINK . $dataModel['image'], "newImage" => $dataModel['image']));
            exit;
        }
    }


}

?>
