<?php
    class Employee extends Controller{
		
        
        public function add()
        {
            
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("error","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            
            //start Add Anew Employee
			if(isset($_POST['add']))
            {
                
                // preparing validation array
                $validationArray = array(
                                            "name"=>array(
                                                "value"=> $this->loadSecurity($_POST['name'])->clear(),
                                                "errorName"=>"Employee Name",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "email"=>array(
                                                "value"=> $this->loadSecurity($_POST['email'])->clear(),
                                                "errorName"=>"Email",
                                                "rules"=>"required|email"
                                            ),
                                            "phone"=>array(
                                                "value"=> $this->loadSecurity($_POST['phone'])->clear(),
                                                "errorName"=>"Phone",
                                                "rules"=>"required"
                                            ),
                                            "birth_date"=>array(
                                                "value"=> $this->loadSecurity($_POST['birth_date'])->clear(),
                                                "errorName"=>"Birth Date",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            
                                            "address"=>array(
                                                "value"=> $this->loadSecurity($_POST['address'])->clear(),
                                                "errorName"=>"Address",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "gender"=>array(
                                                "value"=> $this->loadSecurity($_POST['gender'])->clear(),
                                                "errorName"=>"Gender",
                                                "rules"=>"required|number"
                                            ),
                                            "fixed_salary"=>array(
                                                "value"=> $this->loadSecurity($_POST['fixed_salary'])->clear(),
                                                "errorName"=>"Fixed Salary",
                                                "rules"=>"required"
                                            ),
                                            "fixed_commision"=>array(
                                                "value"=> $this->loadSecurity($_POST['fixed_commision'])->clear(),
                                                "errorName"=>"Fixed Commision",
                                            ),
                                            "ssn"=>array(
                                                "value"=> $this->loadSecurity($_POST['ssn'])->clear(),
                                                "errorName"=>"Ssn",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "snapshot"=>array(
                                                "value"=> $this->loadSecurity($_POST['snapshot'])->clear(),
                                                "errorName"=>"snapshot",
                                            ),
                                            "password"=>array(
                                                "value"=> $this->loadSecurity($_POST['password'])->clear(),
                                                "errorName"=>"password",
                                                "rules"=>"required|min-length[6]|max-length[50]|sha1_md5"
                                            ),
                                            "re_password"=>array(
                                                 "value"=>$this->loadSecurity(sha1(md5($_POST['repassword'])))->clear(),
                                                 "errorName"=>"Re-Password",
                                                 "rules"=>"required|match[password]"
                                              ),
                                            "admin_type_id"=>array(
                                                "value"=> $this->loadSecurity($_POST['admin_type'])->clear(),
                                                "errorName"=>"Admin Type",
                                                "rules"=>"required|number"
                                            ),
                                            "status"=>array(
                                                "value"=> $this->loadSecurity($_POST['status'])->clear(),
                                                "errorName"=>"Status",
                                                "rules"=>"required|number"
                                            )
                                  );
                // load validation classs and pass validation data
                $dataValid = $this->loadValidation($validationArray)->formValidate();
                // check if the data is ok
                if(is_array($dataValid) && array_key_exists("success",$dataValid))
                { 
                    //check if Mail exists before
                    if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `mail` =? AND `deleted`=?",array($dataValid['success']['email'],1)))
                    {
                        //check if Phone exists before
                        if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `phone` =? AND `deleted`=?",array($dataValid['success']['phone'],1)))
                        {
                            // start upload Employee Profile Pic
                            $upload = $this->loadUpload("profile_picture")->do_upload();
                            // check if there is error on image
                            if(!array_key_exists("uploadError",$upload))
                            {
                                // try to upload ssn image 
                                $uploadSsn = $this->loadUpload("ssn_image")->do_upload();
                                // check if there is error on image
                                if(!array_key_exists("uploadError",$uploadSsn))
                                {
                                    // preparing user model
                                    $userModel['name'] = $dataValid['success']['name'];
                                    $userModel['phone'] = $dataValid['success']['phone'];
                                    $userModel['mail'] = $dataValid['success']['email'];
                                    $userModel['password'] = $dataValid['success']['password'];
                                    $userModel['address'] = $dataValid['success']['address'];
                                    $userModel['photo'] = $upload['uploaded'][0];
                                    $userModel['gender'] = $dataValid['success']['gender'];
                                    $userModel['job_type'] = 1;
                                    $userModel['verified'] = 1;
                                    $userModel['created_by'] = $user_id;
                                    $userModel['created'] = time();
                                    $userModel['last_updated_by'] = $user_id;
                                    $userModel['status'] = $dataValid['success']['status'];
                                    // add user 
                                    $add = $this->loadModel("UserModel", $userModel)->add();
                                    // call user Model 
                                    if(FALSE !== $add)
                                    {
                                        $employeeModel['user_id'] = $add;
                                        $employeeModel['fixed_salary'] = $dataValid['success']['fixed_salary'];
                                        $employeeModel['fixed_commision'] = $dataValid['success']['fixed_commision'];
                                        $employeeModel['fixed_salary'] = $dataValid['success']['fixed_salary'];
                                        $employeeModel['ssn_image'] = $uploadSsn['uploaded'][0];
                                        $employeeModel['ssn'] = $dataValid['success']['ssn'];
                                        $employeeModel['birth_date'] = $dataValid['success']['birth_date'];
                                        $employeeModel['snapshot'] = $dataValid['success']['snapshot'];
                                        $employeeModel['admin_type_id'] = $dataValid['success']['admin_type_id'];
                                        $employeeModel['created_by'] = $user_id;
                                        $employeeModel['created'] = time();
                                        $employeeModel['last_updated_by'] = $user_id;
                                        $employeeModel['status'] = $dataValid['success']['status'];
                                        // add employee
                                        $addEmployee = $this->loadModel("EmployeeModel", $employeeModel)->add();
                                        if(FALSE !== $addEmployee)
                                        {
                                            $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Added Successfully Please Wait .. </div>';
                                             header("Refresh: 2");
                                        }else{
                                            // delete user
                                            $this->loadModel("UserModel",array("deleted"=>2))->updateData("id",$add);
                                            $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding Employee Data</div>';
                                        }
                                    }else{
                                        $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Adding User Data</div>';
                                    }
                                }else{
                                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Ssn Image Is Required (Max Image Size 2MB)</div>';
                                }
                            }else{
                                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Profile Image Is Required (Max Image Size 2MB)</div>';
                            }
                        }else{
                            $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Phone Exists Before </div>';
                        }
                    }else{
                        $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Email Exists Before </div>';
                    }
                }else{
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
                }
            }

            // get alladmin Types
            $dataView["adminTypes"] = $this->loadModel("AdminTypesModel")->retrieveAllData("WHERE `deleted` =? ",array(1));
			
            $dataView['title'] = "Add a New Employee";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "employee" . DIRECTORY_SEPARATOR . "employee_add";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        
        public function getAll()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("error","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            
            // get all employees
            $dataView['users'] =  $this->loadModel("UserModel")->retrieveAllData("WHERE `job_type` =? AND `deleted` =?",array(1,1));
            

			$dataView['title'] = "Show / Edit Employees";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "employee" . DIRECTORY_SEPARATOR . "employee_getall";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        
        public function edit_selected()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("error","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("error","index");
                exit();
            }
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =?  AND `deleted` =?",array($id,1));
            if($dataView['user'] == NULL)
            {
                $this->redirect("error","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            
            // get data
            $dataView['employee'] = $this->loadModel("EmployeeModel")->retrieveAllData("WHERE `user_id` =? AND `deleted` =?",array($id,1));
            if($dataView['employee'] == NULL)
            {
                $this->redirect("error","index");
                exit();
            }
            $dataView['employee'] = array_shift($dataView['employee']);
            
            //start Edit employee
			if(isset($_POST['edit']))
            {
                
                // preparing validation array
                $validationArray = array(
                                            "name"=>array(
                                                "value"=> $this->loadSecurity($_POST['name'])->clear(),
                                                "errorName"=>"Employee Name",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "mail"=>array(
                                                "value"=> $this->loadSecurity($_POST['email'])->clear(),
                                                "errorName"=>"Email",
                                                "rules"=>"required|email"
                                            ),
                                            "phone"=>array(
                                                "value"=> $this->loadSecurity($_POST['phone'])->clear(),
                                                "errorName"=>"Phone",
                                                "rules"=>"required"
                                            ),
                                            "birth_date"=>array(
                                                "value"=> $this->loadSecurity($_POST['birth_date'])->clear(),
                                                "errorName"=>"Birth Date",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            
                                            "address"=>array(
                                                "value"=> $this->loadSecurity($_POST['address'])->clear(),
                                                "errorName"=>"Address",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "gender"=>array(
                                                "value"=> $this->loadSecurity($_POST['gender'])->clear(),
                                                "errorName"=>"Gender",
                                                "rules"=>"required|number"
                                            ),
                                            "fixed_salary"=>array(
                                                "value"=> $this->loadSecurity($_POST['fixed_salary'])->clear(),
                                                "errorName"=>"Fixed Salary",
                                                "rules"=>"required"
                                            ),
                                            "fixed_commision"=>array(
                                                "value"=> $this->loadSecurity($_POST['fixed_commision'])->clear(),
                                                "errorName"=>"Fixed Commision",
                                            ),
                                            "ssn"=>array(
                                                "value"=> $this->loadSecurity($_POST['ssn'])->clear(),
                                                "errorName"=>"Ssn",
                                                "rules"=>"required|min-length[3]|max-length[50]"
                                            ),
                                            "snapshot"=>array(
                                                "value"=> $this->loadSecurity($_POST['snapshot'])->clear(),
                                                "errorName"=>"snapshot",
                                            ),
                                            
                                            "admin_type_id"=>array(
                                                "value"=> $this->loadSecurity($_POST['admin_type'])->clear(),
                                                "errorName"=>"Admin Type",
                                                "rules"=>"required|number"
                                            ),
                                            "status"=>array(
                                                "value"=> $this->loadSecurity($_POST['status'])->clear(),
                                                "errorName"=>"Status",
                                                "rules"=>"required|number"
                                            )
                                  );
                // load validation classs and pass validation data
                $dataValid = $this->loadValidation($validationArray)->formValidate();
                // check if the data is ok
                if(is_array($dataValid) && array_key_exists("success",$dataValid))
                { 
                    //check if Mail exists before
                    if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `mail` =? AND `id`!=? AND `deleted`=?",array($dataValid['success']['mail'],$id,1)))
                    {
                        //check if User phone exists before
                        if(TRUE !== $this->loadModel("UserModel")->CheckExists("WHERE `phone` =? AND `id`!=? AND `deleted`=?",array($dataValid['success']['phone'],$id,1)))
                        {
                            // preparing user model
                            $userModel['name'] = $dataValid['success']['name'];
                            $userModel['phone'] = $dataValid['success']['phone'];
                            $userModel['mail'] = $dataValid['success']['mail'];
                            $userModel['address'] = $dataValid['success']['address'];
                            $userModel['gender'] = $dataValid['success']['gender'];
                            $userModel['last_updated_by'] = $user_id;
                            $userModel['status'] = $dataValid['success']['status'];
                            // update user 
                            $updateUser = $this->loadModel("UserModel", $userModel)->updateData("id",$id);
                            // call user Model 
                            if(FALSE !== $updateUser)
                            {
                                $employeeModel['fixed_salary'] = $dataValid['success']['fixed_salary'];
                                $employeeModel['fixed_commision'] = $dataValid['success']['fixed_commision'];
                                $employeeModel['fixed_salary'] = $dataValid['success']['fixed_salary'];
                                $employeeModel['ssn'] = $dataValid['success']['ssn'];
                                $employeeModel['snapshot'] = $dataValid['success']['snapshot'];
                                $employeeModel['birth_date'] = $dataValid['success']['birth_date'];
                                $employeeModel['admin_type_id'] = $dataValid['success']['admin_type_id'];
                                $employeeModel['last_updated_by'] = $user_id;
                                $employeeModel['status'] = $dataValid['success']['status'];
                                // edit employee
                                $updateEmployee = $this->loadModel("EmployeeModel", $employeeModel)->updateData("user_id",$id);
                                if(FALSE !== $updateEmployee)
                                {
                                    $dataView['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully Please Wait .. </div>';
                                    header("Refresh: 2"); 
                                }else{
                                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Employee Data</div>';
                                }
                            }else{
                                $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating User Data</div>';
                            }
                        }else{
                            $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Phone Exists Before </div>';
                        }
                    }else{
                        $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> User Email Exists Before </div>';
                    }
                }else{
                    $dataView['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
                }
            }
            

            
            // get alladmin Types
            $dataView["adminTypes"] = $this->loadModel("AdminTypesModel")->retrieveAllData("WHERE `deleted` =? ",array(1));
			
            // set page title
			$dataView['title'] = "Edit Selected Employee";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "employee" . DIRECTORY_SEPARATOR ."employee_edit_selected";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        
        public function show_selected()
        {
			/******** start header code ********/
            if(FALSE !== $this->loadHelper("UserHelper")->check_user_login())
            {
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                // get user data for header
                $dataView['userData'] = $this->loadModel("UserModel")->retriveDataById("id",$user_id);
                $dataView['employeeData'] = $this->loadModel("EmployeeModel")->retriveDataById("user_id",$user_id);
                if($dataView['userData'] == NULL)
                {
                    $this->redirect("error","index");
                    exit();
                }
            }else{
                $this->redirect("admin","login");
            }

            /******* end header code *******/
            // get id from url
            $id = (int)$this->loadRoute()->getSegment(2);
            if($id == 0)
            {
                $this->redirect("error","index");
                exit();
            }
            // get data
            $dataView['user'] = $this->loadModel("UserModel")->retrieveAllData("WHERE `id` =?  AND `deleted` =?",array($id,1));
            if($dataView['user'] == NULL)
            {
                $this->redirect("error","index");
                exit();
            }
            $dataView['user'] = array_shift($dataView['user']);
            
            
            $dataView['employee'] = $this->loadModel("EmployeeModel")->retrieveAllData("WHERE `user_id` =? AND `deleted` =?",array($id,1));
            if($dataView['employee'] == NULL)
            {
                $this->redirect("error","index");
                exit();
            }
            $dataView['employee'] = array_shift($dataView['employee']);
            
            // get employee type
            $dataView['employeeType'] = $this->loadModel("AdminTypesModel")->retriveDataById("id",$dataView['employee']['admin_type_id']);
            
            // get user created by
            $dataView['createdBy'] = $this->loadModel("UserModel")->retriveDataById("id",$dataView['user']['created_by']);
            // get last update by
            $dataView['LastUpdatedBy'] = $this->loadModel("UserModel")->retriveDataById("id",$dataView['user']['last_updated_by']);
            // set page title
			$dataView['title'] = "View Selected Employee";
            // global Template Config
            global $TEMPLATE_BACK_END ;
            // set content
            $TEMPLATE_BACK_END['files']['content'] = BACK_END_CONTROL_PATH . "employee" . DIRECTORY_SEPARATOR ."employee_show_selected";
            // load template
            $this->loadTemplate($TEMPLATE_BACK_END,$dataView)->render();
        }
        
        public function updateStatus()
        {
                if(isset($_POST['action'],$_POST['id'],$_POST['status']) && $_POST['action'] == "updateStatus")
                {
                    // get User id
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("error","index");
                        exit;
                    }else{
                        // get current status
                        $currentStatus = $_POST['status'];
                        // if current status = on set it off
                        if($currentStatus == "on")
                        {
                            $setStatus = 2;
                        }else{
                            $setStatus = 1;
                        }
                        $dataModel['status'] = $setStatus;
                        // get user id from session
                        $dataModel['last_updated_by'] = $this->loadSession()->getSession("user_id");
                        if(false !== $this->loadModel("UserModel",$dataModel)->updateData("id", $id))
                        {
                            // update employee table
                            $this->loadModel("EmployeeModel",$dataModel)->updateData("user_id", $id);
                            echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                            exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                }
         }
        public function update_image()
        {
                //get id
                $id = (int)$_POST['field_id'];
                 if($id == 0)
                {
                    $this->redirect("error","index");
                    exit;
                }else{
                        $upload = $this->loadUpload("image_name")->do_upload();
                       // check if there is error on image
                       if(array_key_exists("uploadError",$upload))
                       {
                           echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                            exit;

                       }else{
                           // get user id from session
                           $last_updated_by = $this->loadSession()->getSession("user_id");
                           $dataModel['photo'] = $upload['uploaded'][0];
                           $dataModel['last_updated_by'] = $last_updated_by;
                           
                           if(false !== $this->loadModel("UserModel",$dataModel)->updateData("id", $id))
                           {
                               // update employee table
                               $this->loadModel("EmployeeModel",array("last_updated_by"=>$last_updated_by))->updateData("user_id",$id);
                               echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['photo']));
                               exit; 
                           }else{
                              echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                            exit;
                           }
                       }
                    }  
        }
        public function delete()
        {
                if(isset($_POST['action'],$_POST['id']) && $_POST['action'] == "deleteData")
                {
                    $id = (int)$_POST['id'];
                    if($id == 0)
                    {
                        $this->redirect("error","index");
                        exit;
                    }else{
                        // get user id from session
                        $last_updated_by = $this->loadSession()->getSession("user_id");
                        if(FALSE !== $this->loadModel("UserModel",array("deleted"=>2,"last_updated_by"=>$last_updated_by))->updateData("id", $id))
                        {
                            // update employee table
                            $this->loadModel("EmployeeModel",array("deleted"=>2,"last_updated_by"=>$last_updated_by))->updateData("user_id",$id);
                            echo $this->loadAjax()->DataToJson(array("status"=>"success"));
                            exit;
                        }else{
                            echo $this->loadAjax()->DataToJson(array("status"=>"faild"));
                            exit;
                        }
                    }
                 }
         }
        public function update_password()
        {
            if(isset($_POST['action']) && $_POST['action'] == 'editPass')
            {
               // preparing validation array
                $validationArray = array(
                                        "user_id"=>array(
                                                             "value"=>$this->loadSecurity($_POST['user_id'])->clear(),
                                                             "errorName"=>"User Id",
                                                             "rules"=>"required|number"
                                                          ),
                                            "password"=>array(
                                                             "value"=>$this->loadSecurity($_POST['password'])->clear(),
                                                             "errorName"=>"New Password",
                                                             "rules"=>"required|min-length[6]|sha1_md5"
                                                          ),
                                            "re_password"=>array(
                                                             "value"=>$this->loadSecurity(sha1(md5($_POST['repassword'])))->clear(),
                                                             "errorName"=>"Re-Password",
                                                             "rules"=>"required|match[password]"
                                                          )
                                  );
                // load validation classs and pass validation data
                $dataValid = $this->loadValidation($validationArray)->formValidate();
                // check if the data is ok
                if(is_array($dataValid) && array_key_exists("success",$dataValid))
                {
                    $user_id = $dataValid['success']['user_id'];
                    // unset old password from success array
                    unset($dataValid['success']['re_password']);
                    unset($dataValid['success']['user_id']);
                    // get user id from session
                    $dataValid['success']['last_updated_by'] = $this->loadSession()->getSession("user_id");
                    if(false !== $this->loadModel("UserModel",$dataValid['success'])->updateData("id",$user_id))
                    {
                        $response['status'] = "success";
                        $response['message'] = '<div class="alert alert-success" role="alert"><staong><i class="fa fa-check" aria-hidden="true"></i> Success </strong> Your Data Updated Successfully. </div>';
                        echo $this->loadAjax()->DataToJson($response);
                        exit;
                    }else{
                        $response['status'] = "faild";
                        $response['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong> Error Updating Your Data</div>';
                        echo $this->loadAjax()->DataToJson($response);
                        exit;
                    }
                    
                }else{
                    $response['status'] = "faild";
                    $response['message'] = '<div class="alert alert-danger" role="alert"><staong><i class="fa fa-times" aria-hidden="true"></i> Error ! </strong>'.$dataValid.'</div>';
                    echo $this->loadAjax()->DataToJson($response);
                    exit;
                } 
            }
        }
        public function update_ssn_image()
        {
                //get id
                $id = (int)$_POST['field_id'];
                 if($id == 0)
                {
                    echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                    exit;
                }else{
                        $upload = $this->loadUpload("image_name")->do_upload();
                       // check if there is error on image
                       if(array_key_exists("uploadError",$upload))
                       {
                           echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                            exit;

                       }else{
                           $dataModel['ssn_image'] = $upload['uploaded'][0];
                           if(false !== $this->loadModel("EmployeeModel",$dataModel)->updateData("user_id", $id))
                           {
                               echo $this->loadAjax()->DataToJson(array("status"=>"success","newImage"=>$dataModel['ssn_image']));
                                exit; 
                           }else{
                              echo $this->loadAjax()->DataToJson(array("status"=>"falid"));
                             exit;
                           }
                       }
                    }  
        }
        
    }

?>