<?php

class Gallery extends Controller
{

    private function getSEO()
    {
        $url = parse_url($_SERVER['REQUEST_URI']);
        $slug = $url['path'];
        $result = $this->loadModel("SeoModel")->retrieveAllData("WHERE `slug` =? ", array($slug));
        if($result && count($result)) {
            $seo = $result[0];
        } else {
            $seo = [
                'slug' => null,
                'title' => null,
                'keywords' => null,
                'content' => null
            ];
        }

        return $seo;
    }

    public function index()

    {


        $dataView['SEO'] = $this->getSEO();

        /******* end header code *******/
        $dataView['current'] = "photos";
        /// photo
        $dataView['photos'] = $this->loadModel("ImageGalleryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['photos'])) {
            foreach ($dataView['photos'] as $key => $value) {
                // get ar and en Data
                $dataView['photosLang'][$key] = $this->loadModel("ImageGalleryEnModel")->retriveDataById("id_image_gallery", $value['id']);
            }
        }


        // set page title
        $dataView['title'] = " EG | Home Page";
        // global Template Config
        global $TEMPLATE_FRONT_END;

        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "gallery_view";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function SendMessageForm()
    {
        if (isset($_POST['action']) && $_POST['action'] == "addsentmessagedata") {
            // preparing validation array
            $validationArray = array(
                "fname_data" => array(
                    "value" => $this->loadSecurity($_POST['fname'])->clear(),
                    "errorName" => "First  Name",
                    "rules" => "required|min-length[1]"
                ),
                "lname_data" => array(
                    "value" => $this->loadSecurity($_POST['lname'])->clear(),
                    "errorName" => "Last  Name",
                    "rules" => "required|min-length[1]"
                ),
                "phone_data" => array(
                    "value" => $this->loadSecurity($_POST['phone'])->clear(),
                    "errorName" => "Phone",
                    "rules" => "required|number|min-length[1]"
                ),
                "email_data" => array(
                    "value" => $this->loadSecurity($_POST['email'])->clear(),
                    "errorName" => "Email",
                    "rules" => "required|min-length[1]"
                ),
                "message_data" => array(
                    "value" => $this->loadSecurity($_POST['message'])->clear(),
                    "errorName" => " Message",
                    "rules" => "required|min-length[1]"
                ),
            );
            // load validation class and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                $datToModel['fname'] = $dataValid['success']['fname_data'];
                $datToModel['lname'] = $dataValid['success']['lname_data'];
                $datToModel['phone'] = $dataValid['success']['phone_data'];
                $datToModel['mail'] = $dataValid['success']['email_data'];
                $datToModel['message'] = $dataValid['success']['message_data'];
                $datToModel['created'] = time();
                $dataValid['success']['date'] = date('Y-m-d h:i:s');
                $add = $this->loadModel("UserMessageModel", $datToModel)->add();
                if (FALSE !== $add) {
                    $data['status'] = "success";
                    $data['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> All Data Added Successfully <strong> Thanks....</strong></div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                } else {
                    $data['status'] = "failed";
                    $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> <strong>Failed ! </strong> Failed To Send This Request Please Try Again....</div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                }

            } else {
                $data['status'] = "failed";
                $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Failed ! </strong> ' . $dataValid . '</div>';
                echo $this->loadAjax()->DataToJson($data);
                exit();
            }

        }
    }

    public function SendRequestForm()
    {
        if (isset($_POST['action']) && $_POST['action'] == "addsentrequestdata") {
            // preparing validation array
            $validationArray = array(
                "name_data" => array(
                    "value" => $this->loadSecurity($_POST['name'])->clear(),
                    "errorName" => " Name",
                    "rules" => "required|min-length[1]"
                ),
                "email_data" => array(
                    "value" => $this->loadSecurity($_POST['email'])->clear(),
                    "errorName" => "Email",
                    "rules" => "required|email|min-length[1]"
                ),
                "subject_data" => array(
                    "value" => $this->loadSecurity($_POST['subject'])->clear(),
                    "errorName" => "subject",
                    "rules" => "required|min-length[1]"
                ),
                "message_data" => array(
                    "value" => $this->loadSecurity($_POST['message'])->clear(),
                    "errorName" => " Message",
                    "rules" => "required|min-length[1]"
                ),
            );
            // load validation class and pass validation data
            $dataValid = $this->loadValidation($validationArray)->formValidate();
            // check if the data is ok
            if (is_array($dataValid) && array_key_exists("success", $dataValid)) {
                // add
                $datToModel['name'] = $dataValid['success']['name_data'];
                $datToModel['mail'] = $dataValid['success']['email_data'];
                $datToModel['subject'] = $dataValid['success']['subject_data'];
                $datToModel['message'] = $dataValid['success']['message_data'];
                // get user id from session
                $user_id = $this->loadSession()->getSession("user_id");
                $datToModel['created_by'] = $user_id;
                $datToModel['createdAt'] = date('Y-m-d h:i:s');
                $add = $this->loadModel("RequestModel", $datToModel)->add();
                if (FALSE !== $add) {
                    $data['status'] = "success";
                    $data['message'] = '<div class="alert alert-success" role="alert"><strong><i class="fa fa-check" aria-hidden="true"></i> All Data Added Successfully <strong> Thanks....</strong></div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                } else {
                    $data['status'] = "failed";
                    $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> <strong>Failed ! </strong> Failed To Send This Request Please Try Again....</div>';
                    echo $this->loadAjax()->DataToJson($data);
                    exit();
                }
            } else {
                $data['status'] = "failed";
                $data['message'] = '<div class="alert alert-danger" role="alert"><strong><i class="fa fa-times" aria-hidden="true"></i> Failed ! </strong> ' . $dataValid . '</div>';
                echo $this->loadAjax()->DataToJson($data);
                exit();
            }
        }
    }

    public function aboutus()
    {

        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "aboutus";
        /******* end header code *******/


        //GALLERIES
        $dataView['galleries'] = $this->loadModel("AboutusImagesModel")->retrieveAllData("WHERE `status` =? AND `deleted` =? ", array(1, 1));

        /// About
        $dataView['about'] = $this->loadModel("AboutusModel")->retriveDataById("id", 1);
        $dataView['aboutLang'] = $this->loadModel("AboutusEnModel")->retriveDataById("id_about_us", 1);


        /// branches
        $dataView['branches'] = $this->loadModel("BranchesModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));
        if (is_array($dataView['branches'])) {
            foreach ($dataView['branches'] as $key => $value) {
                // get ar and en Data
                $dataView['branchesLang'][$key] = $this->loadModel("BranchesEnModel")->retriveDataById("id_branch", $value['id']);
                $dataView['branchesPhone'][$key] = $this->loadModel("BranchesPhoneModel")->retrieveAllData("WHERE `id_branch`=? AND `status`=? AND `deleted` =?",array($value['id'],1,1));
            }
        }


        $dataView['title'] = "EG | About us";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "aboutus";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function clients()
    {

        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "clients";
        /******* end header code *******/


        $dataView['clients'] = $this->loadModel("GalleryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?   ", array(1, 1));



        $dataView['title'] = "EG | Clients ";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "clients";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }

    public function contactus()
    {

        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "contactus";


        $dataView['title'] = "EG | Contact Us";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "contactus";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }


}

?>
