<?php

class Category extends Controller
{

    private function getSEO()
    {
        $url = parse_url($_SERVER['REQUEST_URI']);
        $slug = $url['path'];
        $result = $this->loadModel("SeoModel")->retrieveAllData("WHERE `slug` =? ", array($slug));
        if($result && count($result)) {
            $seo = $result[0];
        } else {
            $seo = [
                'slug' => null,
                'title' => null,
                'keywords' => null,
                'content' => null
            ];
        }

        return $seo;
    }

    public function view()

    {
        $dataView['SEO'] = $this->getSEO();
        $dataView['current'] = "offers";
        //categories
        $dataView['categories'] = $this->loadModel("CategoryModel")->retrieveAllData("WHERE `status` =? AND `deleted` =?", array(1, 1));
        if (is_array($dataView['categories'])) {
            foreach ($dataView['categories'] as $key => $value) {
                // get ar and en Data
                $dataView['categoriesLang'][$key] = $this->loadModel("CategoryArModel")->retriveDataById("id_category", $value['id']);
                // products
                $dataView['products'][$key] = $this->loadModel("OfferModel")->retrieveAllData("WHERE `id_category` =? AND `status` =? AND `deleted` =?", array($value['id'], 1, 1));
                foreach ($dataView['products'][$key] as $key2 => $data) {
                    $dataView['productsLang'][$key][$key2] = $this->loadModel("OfferArModel")->retriveDataById("id_offer", $data['id']);
                }

            }
        }



        // set page title
        $dataView['title'] = "المصرية للمعادن| المنتجات";
        // global Template Config
        global $TEMPLATE_FRONT_END;
        // set content
        $TEMPLATE_FRONT_END['files']['content'] = FRONT_END_CONTROL_PATH . "offers_view";
        // load template
        $this->loadTemplate($TEMPLATE_FRONT_END, $dataView)->render();

    }



}

?>
