<?php if(!empty($metatags)): ?>
    
    <meta charset="<?php echo e($metatags['charset'] ?? 'utf-8'); ?>">
    <meta name="viewport" content="<?php echo e($metatags['viewport'] ?? 'width=device-width, initial-scale=1.0'); ?>">
    <meta http-equiv="Content-Language" content="<?php echo e($metatags['language'] ?? 'en'); ?>">
    <meta name="robots" content="<?php echo e($metatags['robots'] ?? 'index, follow'); ?>">
    <meta name="description" content="<?php echo e($metatags['description'] ?? ''); ?>">
    <?php if(!empty($metatags['keywords'])): ?>
        <meta name="keywords" content="<?php echo e($metatags['keywords']); ?>">
    <?php endif; ?>
    <meta name="author" content="<?php echo e($metatags['author'] ?? ''); ?>">
    <title><?php echo e($metatags['title'] ?? config('settings.site_name')); ?></title>

    <?php if(!empty($metatags['time'])): ?>
        <meta name="time" content="<?php echo e($metatags['time']); ?>">
    <?php endif; ?>

    
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta http-equiv="Content-Security-Policy" content="upgrade-insecure-requests">
    <meta http-equiv="Strict-Transport-Security" content="max-age=31536000; includeSubDomains; preload">

    
    <?php if(!empty($metatags['canonical'])): ?>
        <link rel="canonical" href="<?php echo e($metatags['canonical']); ?>">
    <?php else: ?>
        <?php
            $currentUrl = url()->current();
            $currentPath = request()->path();

            // Fix canonical for blog redirect - if path is /ar/blog or /en/blog, use /blogs
            if (preg_match('/^(ar|en)\/blog$/', $currentPath)) {
                $currentUrl = str_replace('/blog', '/blogs', $currentUrl);
            }
        ?>
        <link rel="canonical" href="<?php echo e($currentUrl); ?>">
    <?php endif; ?>


    
    <link rel="icon" href="<?php echo e(\App\Helper\Path::FavIcon()); ?>" type="image/x-icon">
    <link rel="icon" href="<?php echo e(asset('favicon.png')); ?>" type="image/png">
    <link rel="apple-touch-icon" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="152x152" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="144x144" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="120x120" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="114x114" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="76x76" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="72x72" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="60x60" href="<?php echo e(asset('favicon.png')); ?>">
    <link rel="apple-touch-icon" sizes="57x57" href="<?php echo e(asset('favicon.png')); ?>">
    
    <meta name="msapplication-TileImage" content="<?php echo e(asset('favicon.png')); ?>">
    <meta name="msapplication-config" content="<?php echo e(asset('browserconfig.xml')); ?>">

    
    <meta property="og:title" content="<?php echo e($metatags['og_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta property="og:description" content="<?php echo e($metatags['og_description'] ?? ($metatags['description'] ?? '')); ?>">
    <?php
        $ogUrl = url()->current();
        $currentPath = request()->path();

        // Fix OG URL for blog redirect
        if (preg_match('/^(ar|en)\/blog$/', $currentPath)) {
            $ogUrl = str_replace('/blog', '/blogs', $ogUrl);
        }
    ?>
    <meta property="og:url" content="<?php echo e($metatags['og_url'] ?? $ogUrl); ?>">
    <meta property="og:image" content="<?php echo e($metatags['og_image'] ?? asset('images/default-og.jpg')); ?>">
    <meta property="og:image:width" content="1200">
    <meta property="og:image:height" content="630">
    <meta property="og:image:alt" content="<?php echo e($metatags['og_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta property="og:type" content="<?php echo e($metatags['og_type'] ?? 'website'); ?>">
    <meta property="og:site_name" content="<?php echo e($metatags['og_site_name'] ?? config('settings.site_name')); ?>">
    <meta property="og:locale" content="<?php echo e($metatags['og_locale'] ?? app()->getLocale()); ?>">

    
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:title" content="<?php echo e($metatags['twitter_title'] ?? ($metatags['title'] ?? '')); ?>">
    <meta name="twitter:description"
        content="<?php echo e($metatags['twitter_description'] ?? ($metatags['description'] ?? '')); ?>">
    <meta name="twitter:image" content="<?php echo e($metatags['twitter_image'] ?? asset('images/default-og.jpg')); ?>">
    <meta name="twitter:url" content="<?php echo e($metatags['twitter_url'] ?? $ogUrl); ?>">
    <?php if(!empty($metatags['twitter_site'])): ?>
        <meta name="twitter:site" content="<?php echo e($metatags['twitter_site']); ?>">
    <?php endif; ?>
    <?php if(!empty($metatags['twitter_creator'])): ?>
        <meta name="twitter:creator" content="<?php echo e($metatags['twitter_creator']); ?>">
    <?php endif; ?>

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link rel="dns-prefetch" href="//www.google-analytics.com">
    <link rel="dns-prefetch" href="//www.googletagmanager.com">

    
    <?php
        $locales = ['ar', 'en'];
        $currentPath = request()->path();
        $pathWithoutLocale = preg_replace('/^(ar|en)\/?/', '', $currentPath);

        // Check if this is a blog page
        if (preg_match('/^blog\/(.+)$/', $pathWithoutLocale, $matches)) {
            $currentSlug = urldecode($matches[1]);
            $currentLocale = app()->getLocale();

            // Try to find the blog using current locale first
            $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.{$currentLocale}') = ?", [$currentSlug])->first();

            // If not found, try all locales
            if (!$blog) {
                foreach (['ar', 'en'] as $lang) {
                    $blog = \App\Models\Blog::whereRaw("JSON_EXTRACT(slug, '$.{$lang}') = ?", [$currentSlug])->first();
                    if ($blog) {
                        break;
                    }
                }
            }

            // If not found with JSON_EXTRACT, try manual search
            if (!$blog) {
                $blogs = \App\Models\Blog::all();
                foreach ($blogs as $b) {
                    foreach (['ar', 'en'] as $lang) {
                        $blogSlug = $b->getTranslation('slug', $lang);
                        if ($blogSlug === $currentSlug) {
                            $blog = $b;
                            break 2;
                        }
                    }
                }
            }

            if ($blog) {
                $generatedUrls = [];

                // Generate URLs for each locale
                foreach ($locales as $locale) {
                    $localizedUrl = $blog->getLocalizedUrl($locale);
                    if ($localizedUrl) {
                        $generatedUrls[$locale] = $localizedUrl;
                        echo '<link rel="alternate" hreflang="' . $locale . '" href="' . $localizedUrl . '" />' . "\n";
                    }
                }

                // Add x-default only if we have Arabic URL (default language)
                if (isset($generatedUrls['ar'])) {
                    echo '<link rel="alternate" hreflang="x-default" href="' . $generatedUrls['ar'] . '" />' . "\n";
                }
            } else {
                // Fallback to simple method if blog not found
                $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
                foreach ($locales as $locale) {
                    echo '<link rel="alternate" hreflang="' .
                        $locale .
                        '" href="' .
                        url('/' . $locale . $path) .
                        '" />' .
                        "\n";
                }
                // Add x-default pointing to Arabic
                echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />' . "\n";
            }
        } else {
            // For non-blog pages, use the simple method
            $path = $pathWithoutLocale ? '/' . $pathWithoutLocale : '';
            foreach ($locales as $locale) {
                echo '<link rel="alternate" hreflang="' .
                    $locale .
                    '" href="' .
                    url('/' . $locale . $path) .
                    '" />' .
                    "\n";
            }
            // Add x-default pointing to Arabic
            echo '<link rel="alternate" hreflang="x-default" href="' . url('/ar' . $path) . '" />' . "\n";
        }
    ?>

    
    <?php if(config('settings.google_tag_manager_id')): ?>
        <script>
            (function(w, d, s, l, i) {
                w[l] = w[l] || [];
                w[l].push({
                    'gtm.start': new Date().getTime(),
                    event: 'gtm.js'
                });
                var f = d.getElementsByTagName(s)[0],
                    j = d.createElement(s),
                    dl = l != 'dataLayer' ? '&l=' + l : '';
                j.async = true;
                j.src =
                    'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
                f.parentNode.insertBefore(j, f);
            })(window, document, 'script', 'dataLayer',
                '<?php echo e(config('
                                                                                                                                                                                                                                                                                                                                                                                                                                settings.google_tag_manager_id ')); ?>'
            );
        </script>
    <?php endif; ?>

    
    <?php if(config('settings.google_analytics_id')): ?>
        <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('settings.google_analytics_id')); ?>"></script>
        <script>
            window.dataLayer = window.dataLayer || [];

            function gtag() {
                dataLayer.push(arguments);
            }
            gtag('js', new Date());
            gtag('config',
                '<?php echo e(config('
                                                                                                                                                                                                                                                                                                                                                                                                                        settings.google_analytics_id ')); ?>'
            );
        </script>
    <?php endif; ?>
<?php endif; ?>


<?php if(!empty($schema)): ?>
    <script type="application/ld+json">
    {
        !!json_encode($schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!
    }
</script>
<?php else: ?>
    
    <?php
        $schemaUrl = url()->current();
        $currentPath = request()->path();

        // Fix Schema URL for blog redirect
        if (preg_match('/^(ar|en)\/blog$/', $currentPath)) {
            $schemaUrl = str_replace('/blog', '/blogs', $schemaUrl);
        }
    ?>
    <script type="application/ld+json">
    {
        !!json_encode([
            '@context' => 'https://schema.org',
            '@type' => 'WebPage',
            'name' => $metatags['title'] ?? config('settings.site_name'),
            'url' => $metatags['canonical'] ?? $schemaUrl,
            'description' => $metatags['description'] ?? ''
        ], JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!
    }
</script>
<?php endif; ?>


<?php if(!empty($faq_schema)): ?>
    <script type="application/ld+json">
    {
        !!json_encode($faq_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!
    }
</script>
<?php endif; ?>


<?php if(!empty($breadcrumb_schema)): ?>
    <script type="application/ld+json">
    {
        !!json_encode($breadcrumb_schema, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE) !!
    }
</script>
<?php endif; ?>


<?php if(config('settings.google_tag_manager_id')): ?>
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer',
            '<?php echo e(config('
                                                                                                                                                                                                                                                                                                                        settings.google_tag_manager_id ')); ?>'
        );
    </script>
<?php endif; ?>


<?php if(config('settings.google_analytics_id')): ?>
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e(config('settings.google_analytics_id')); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config',
            '<?php echo e(config('
                                                                                                                                                                                                                                                                                                        settings.google_analytics_id ')); ?>'
        );
    </script>
<?php endif; ?>


<?php if(empty($schema)): ?>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "Organization",
        "name": "<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>",
        "url": "<?php echo e(url('/')); ?>",
        "logo": "<?php echo e(asset('assets/website/images/logo.png')); ?>",
        "description": "<?php echo e(config('settings.site_description') ?? 'خدمات تطوير الويب والحلول الرقمية المتكاملة'); ?>",
        "sameAs": [
            "https://www.facebook.com/mibicom",
            "https://x.com/mibicom",
            "https://www.linkedin.com/company/mibicom",
            "https://www.instagram.com/mibicom",
            "https://www.youtube.com/@mibicom"
        ]
    }
</script>
    <script type="application/ld+json">
    {
        "@context": "https://schema.org",
        "@type": "WebSite",
        "name": "<?php echo e(config('settings.site_name') ?? 'ميبيكوم'); ?>",
        "url": "<?php echo e(url('/')); ?>",
        "potentialAction": {
            "@type": "SearchAction",
            "target": "<?php echo e(url('/')); ?>?q={search_term_string}",
            "query-input": "required name=search_term_string"
        }
    }
</script>
<?php endif; ?>




<script>
    // Lazy loading for images
    document.addEventListener('DOMContentLoaded', function() {
        document.querySelectorAll('img').forEach(function(img) {
            img.setAttribute('loading', 'lazy');
        });
    });
</script>


<script src="https://unpkg.com/web-vitals@3/dist/web-vitals.iife.js" crossorigin type="text/javascript"></script>
<script>
    window.addEventListener('load', function() {
        if (typeof webVitals !== 'undefined') {
            try {
                // CLS - Cumulative Layout Shift
                webVitals.getCLS(function(metric) {
                    console.log('CLS:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'CLS',
                            'value': Math.round(metric.value * 1000),
                            'custom_parameter_1': metric.rating,
                            'custom_parameter_2': window.location.pathname
                        });
                    }

                    fetch('/dashboard/performance/store', {
                        method: 'POST',
                        headers: {
                            'Content-Type': 'application/json',
                            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                                ?.getAttribute('content') || ''
                        },
                        body: JSON.stringify({
                            metric: 'CLS',
                            value: metric.value,
                            rating: metric.rating,
                            page: window.location.pathname
                        })
                    }).catch(error => console.log('Performance data not sent:', error));
                });

                // FID - First Input Delay
                webVitals.getFID(function(metric) {
                    console.log('FID:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'FID',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // LCP - Largest Contentful Paint
                webVitals.getLCP(function(metric) {
                    console.log('LCP:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'LCP',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // FCP - First Contentful Paint
                webVitals.getFCP(function(metric) {
                    console.log('FCP:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'FCP',
                            'value': Math.round(metric.value)
                        });
                    }
                });

                // TTFB - Time to First Byte
                webVitals.getTTFB(function(metric) {
                    console.log('TTFB:', metric);
                    if (typeof gtag !== 'undefined') {
                        gtag('event', 'web_vitals', {
                            'event_category': 'Performance',
                            'event_label': 'TTFB',
                            'value': Math.round(metric.value)
                        });
                    }
                });
            } catch (error) {
                console.warn('Web Vitals error:', error);
            }
        } else {
            console.warn('Web Vitals library not loaded');
        }
    });
</script>
<?php /**PATH /home/webtest3/public_html/tulip-new/resources/views/components/seo/head.blade.php ENDPATH**/ ?>