<!-- SEO Component - This includes all meta tags, title, hreflang, and schema -->
<x-seo.head :metatags="$metatags" :schema="$schema" />
{{-- Basic SEO for pages without metatags --}}
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<meta name="description"
    content="{{ config('settings.site_description') ?? 'Professional web development, SEO, and digital marketing services in Egypt' }}">
<title>{{ config('settings.site_name') ?? 'Tulip Website' }}</title>

{{-- PWA Manifest --}}
<link rel="manifest" href="{{ url(app()->getLocale() . '/manifest.json') }}">

{{-- PWA Meta Tags --}}
<meta name="theme-color" content="#007bff">
<meta name="apple-mobile-web-app-capable" content="yes">
<meta name="apple-mobile-web-app-status-bar-style" content="default">
<meta name="apple-mobile-web-app-title" content="{{ config('settings.site_name') ?? 'Tulip Website' }}">
<meta name="msapplication-TileColor" content="#007bff">
<meta name="msapplication-tap-highlight" content="no">

{{-- Apple Touch Icons --}}
<link rel="apple-touch-icon" sizes="180x180" href="{{ asset('favicon.png') }}">
<link rel="apple-touch-icon" sizes="152x152" href="{{ asset('favicon.png') }}">
<link rel="apple-touch-icon" sizes="144x144" href="{{ asset('favicon.png') }}">
<link rel="apple-touch-icon" sizes="120x120" href="{{ asset('favicon.png') }}">

{{-- Microsoft Tiles --}}
<meta name="msapplication-TileImage" content="{{ asset('favicon.png') }}">
<meta name="msapplication-config" content="{{ asset('browserconfig.xml') }}">



<!-- ======== Page title ============ -->
<!-- files css -->
<link rel="shortcut icon" href="{{ Path::AppLogo('site_logo') }}">
<!-- Preload critical images only if they exist on the page -->
{{-- <link rel="preload" as="image" href="{{ asset('assets/website/images/og-image.jpg') }}"
imagesrcset="{{ asset('assets/website/images/og-image.jpg') }} 1x" imagesizes="100vw"> --}}
<!--<< Bootstrap min.css >>-->
<link rel="stylesheet" href="{{ Path::css('bootstrap.min.css') }}">
<!--<< Font Awesome.css >>-->
<link rel="stylesheet" href="{{ Path::css('all.min.css') }}">
<!--<< Animate.css >>-->
<link rel="stylesheet" href="{{ Path::css('animate.css') }}">
<!--<< Magnific Popup.css >>-->
<link rel="stylesheet" href="{{ Path::css('magnific-popup.css') }}">
<!--<< MeanMenu.css >>-->
<link rel="stylesheet" href="{{ Path::css('meanmenu.css') }}">
<!--<< Swiper Bundle.css >>-->
<link rel="stylesheet" href="{{ Path::css('swiper-bundle.min.css') }}">
<!--<< Nice Select.css >>-->
<link rel="stylesheet" href="{{ Path::css('nice-select.css') }}">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/@fancyapps/ui/dist/fancybox.css" />
<!--<< Main.css >>-->
<link rel="stylesheet" href="{{ Path::css('main.css') }}">