<x-dashboard.layout :title="__('dashboard.attributes')">
    <div class="container-fluid">

        <!-- Page Header -->

        <x-dashboard.partials.page-header :header="__('dashboard.attributes')" />

        <!-- End Page Header -->


        <!-- Table -->
        <div class="row">
            <div class="col-12">
                <div class="enhanced-page-header">
                    <div class="card-header d-flex justify-content-between">
                        <h4 class="card-title pt-3">{{ __('dashboard.attributes') }}</h4>

                        <div class="page-title-right d-flex justify-content-end">
                            <x-dashboard.partials.action-buttons
                                createUrl="{{ route('dashboard.attributes.create') }}" />
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable-buttons" class="table table-bordered dt-responsive nowrap w-100">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll" /></th>
                                    <th>{{ __('dashboard.id') }}</th>
                                    <th>{{ __('dashboard.name_en') }}</th>
                                    <th>{{ __('dashboard.name_ar') }}</th>
                                    <th>{{ __('dashboard.icon') }}</th>
                                    <th>{{ __('dashboard.status') }}</th>
                                    <th>{{ __('dashboard.actions') }}</th>
                                </tr>
                            </thead>


                            <tbody>
                                @foreach ($attributes as $attribute)
                                    <tr id="{{ $attribute->id }}">
                                        <td><input type="checkbox" name="checkbox" class="form-check-input check-inputs"
                                                value="{{ $attribute->id }}" /></td>
                                        <td><a
                                                href="{{ route('dashboard.attributes.edit', $attribute->id) }}">{{ $attribute->id }}</a>
                                        </td>
                                        <td><a
                                                href="{{ route('dashboard.attributes.edit', $attribute->id) }}">{{ $attribute->name_en }}</a>
                                        </td>
                                        <td><a
                                                href="{{ route('dashboard.attributes.edit', $attribute->id) }}">{{ $attribute->name_ar }}</a>
                                        </td>
                                        <td>
                                            <a href="{{ route('dashboard.attributes.edit', $attribute->id) }}">
                                                <img src="{{ $attribute->icon_path }}" width="70">
                                            </a>
                                        </td>

                                        <td>
                                            @if ($attribute->status == 1)
                                                <span class="badge bg-success">{{ __('dashboard.yes') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('dashboard.no') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="action-buttons">
                                                <a href="{{ route('dashboard.attributes.edit', $attribute->id) }}"
                                                    class="btn btn-sm btn-primary" title="{{ __('dashboard.edit') }}">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button"
                                                    class="btn btn-sm {{ $attribute->status ? 'btn-success' : 'btn-secondary' }} toggle-status-btn"
                                                    data-id="{{ $attribute->id }}"
                                                    data-status="{{ $attribute->status }}"
                                                    title="{{ __('dashboard.toggle_visibility') }}">
                                                    <i class="fas fa-eye{{ $attribute->status ? '' : '-slash' }}"></i>
                                                </button>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- end cardaa -->
            </div> <!-- end col -->
        </div>
        <!-- end row -->


    </div>

    @push('scripts')
        <script>
            $(document).ready(function() {
                // Toggle Status functionality
                $('.toggle-status-btn').on('click', function() {
                    var button = $(this);
                    var attributeId = button.data('id');
                    var currentStatus = button.data('status');
                    var newStatus = !currentStatus;

                    button.prop('disabled', true);
                    button.find('i').attr('class', 'fas fa-spinner fa-spin');

                    $.ajax({
                        url: "{{ route('dashboard.attributes.toggleStatus', 0) }}".replace('0',
                            attributeId),
                        type: 'POST',
                        data: {
                            _token: "{{ csrf_token() }}"
                        },
                        success: function(response) {
                            if (response.success) {
                                button.data('status', newStatus);
                                if (newStatus) {
                                    button.removeClass('btn-secondary').addClass('btn-success');
                                    button.find('i').attr('class', 'fas fa-eye');
                                } else {
                                    button.removeClass('btn-success').addClass('btn-secondary');
                                    button.find('i').attr('class', 'fas fa-eye-slash');
                                }

                                // Update status badge in the same row
                                var row = button.closest('tr');
                                var statusCell = row.find('td:nth-child(6)'); // Status column
                                if (newStatus) {
                                    statusCell.html(
                                        '<span class="badge bg-success">{{ __('dashboard.yes') }}</span>'
                                    );
                                } else {
                                    statusCell.html(
                                        '<span class="badge bg-danger">{{ __('dashboard.no') }}</span>'
                                    );
                                }

                                toastr.success(response.message);
                            } else {
                                toastr.error(response.message || 'حدث خطأ في تحديث الحالة');
                            }
                        },
                        error: function(xhr) {
                            console.error('Error:', xhr);
                            toastr.error('حدث خطأ في الاتصال');
                        },
                        complete: function() {
                            button.prop('disabled', false);
                        }
                    });
                });
            });
        </script>
    @endpush
</x-dashboard.layout>
