 <form action="<?php echo e(route('variants.get')); ?>" method="GET" id="variant-form">
     <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
     <?php $__currentLoopData = $product->attributes; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productAttribute): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
     <?php
     $attributeName = $productAttribute->attribute->name;
     $attributeId = $productAttribute->attribute_id;
     $variantValues = $product->variants->flatMap(function($variant) use ($attributeId) {
     return $variant->values->filter(function($value) use ($attributeId) {
     return $value->value->attribute_id == $attributeId;
     });
     })->unique('value_id')->values();
     ?>
     <div class="variant-picker-item">
         <div class="variant-picker-label">
             <?php echo e($attributeName); ?>:
             <span class="fw-6 variant-picker-label-value value-current-<?php echo e(strtolower($attributeName)); ?>">
                 <?php echo e($variantValues->first()->value->value ?? ''); ?>

             </span>
         </div>
         <div class="variant-picker-values">
             <?php $__currentLoopData = $variantValues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $variantValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
             <?php
             $value = $variantValue->value;
             $inputId = 'values-' . strtolower($value) . '-' . $attributeId;
             $isChecked = $key === 0;
             ?>

             <input type="radio" name="variant[<?php echo e($attributeId); ?>]" value="<?php echo e($variantValue->value_id); ?>" data-value="<?php echo e($value->value); ?>" data-attribute="<?php echo e($attributeName); ?>" id="<?php echo e($inputId); ?>" <?php if($isChecked): echo 'checked'; endif; ?> hidden>

             <?php if(strtolower($attributeName) === 'color'): ?>
             <label class="hover-tooltip radius-60 color-btn" for="<?php echo e($inputId); ?>" data-color="<?php echo e($value->value); ?>" data-value="<?php echo e($value->value); ?>">
                 <span class="btn-checkbox" style="background-color:<?php echo e($value->code); ?>"></span>
                 <span class="tooltip"><?php echo e(ucfirst($value->value)); ?></span>
             </label>
             <?php else: ?>
             <label class="style-text size-btn" for="<?php echo e($inputId); ?>" data-value="<?php echo e($value->value); ?>">
                 <p><?php echo e($value->value); ?></p>
             </label>
             <?php endif; ?>
             <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
         </div>
     </div>
     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
 </form>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/product-partials/_variant-selector.blade.php ENDPATH**/ ?>