<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" <?php if(app()->getLocale() == 'ar'): ?> dir="rtl" <?php endif; ?>>

<head>
    <meta charset="utf-8">
    <meta content="width=device-width, initial-scale=1, shrink-to-fit=no" name="viewport">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <?php echo $__env->yieldContent('meta'); ?>
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@200;300;400;500;600;700;800;900;1000&display=swap"
        rel="stylesheet">
    <!-- Favicon -->
    <link rel="icon" href="<?php echo e(url('uploads/settings/source/'.config('site_favicon'))); ?>" type="image/x-icon" />

    <!---Fontawesome css-->
    <link href="<?php echo e(asset('assets/back/plugins/fontawesome-free/css/all.min.css')); ?>" rel="stylesheet">

    <!---Ionicons css-->
    <link href="<?php echo e(asset('assets/back/plugins/ionicons/css/ionicons.min.css')); ?>" rel="stylesheet">

    <!---Typicons css-->
    <link href="<?php echo e(asset('assets/back/plugins/typicons.font/typicons.css')); ?>" rel="stylesheet">

    <!---Feather css-->
    <link href="<?php echo e(asset('assets/back/plugins/feather/feather.css')); ?>" rel="stylesheet">

    <!---Falg-icons css-->
    <link href="<?php echo e(asset('assets/back/plugins/flag-icon-css/css/flag-icon.min.css')); ?>" rel="stylesheet">

    <!---Style css-->
    <?php if(app()->getlocale() == 'en'): ?>
    <link href="<?php echo e(asset('assets/back/css/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css/custom-style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css/skins.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css/dark-style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css/custom-dark-style.css')); ?>" rel="stylesheet">
    <?php else: ?>
    <link href="<?php echo e(asset('assets/back/css-rtl/style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css-rtl/custom-style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css-rtl/skins.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css-rtl/dark-style.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('assets/back/css-rtl/custom-dark-style.css')); ?>" rel="stylesheet">
    <?php endif; ?>

    <!---Select2 css-->
    <link href="<?php echo e(asset('assets/back/plugins/select2/css/select2.min.css')); ?>" rel="stylesheet">

    <!---DataTables css-->
    <link href="<?php echo e(asset('assets/back/plugins/datatable/dataTables.bootstrap4.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/back/plugins/datatable/responsivebootstrap4.min.css')); ?>" rel="stylesheet" />
    <link href="<?php echo e(asset('assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.css')); ?>" rel="stylesheet" />

    <!---Fileupload css-->
    <link href="<?php echo e(asset('assets/back/plugins/fileuploads/css/fileupload.css')); ?>" rel="stylesheet" type="text/css" />

    <!---Fancy uploader css-->
    <link href="<?php echo e(asset('assets/back/plugins/fancyuploder/fancy_fileupload.css')); ?>" rel="stylesheet" />

    <!--Mutipleselect css-->
    <?php if(app()->getlocale() == 'en'): ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/back/plugins/multipleselect/multiple-select.css')); ?>">
    <?php else: ?>
    <link rel="stylesheet" href="<?php echo e(asset('assets/back/plugins/multipleselect/multiple-select-rtl.css')); ?>">
    <?php endif; ?>
    <!---Sidebar css-->
    <link href="<?php echo e(asset('assets/back/plugins/sidebar/sidebar.css')); ?>" rel="stylesheet">

    <!---Jquery.mCustomScrollbar css-->
    <link href="<?php echo e(asset('assets/back/plugins/jquery.mCustomScrollbar/jquery.mCustomScrollbar.css')); ?>" rel="stylesheet">

    <!---Sidemenu css-->
    <?php if(app()->getlocale() == 'en'): ?>
    <link href="<?php echo e(asset('assets/back/plugins/sidemenu/sidemenu.css')); ?>" rel="stylesheet">
    <?php else: ?>
    <link href="<?php echo e(asset('assets/back/plugins/sidemenu/sidemenu-rtl.css')); ?>" rel="stylesheet">
    <?php endif; ?>

    <!---Gallery css-->
    <link href="<?php echo e(asset('assets/back/plugins/gallery/gallery.css')); ?>" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <?php echo $__env->yieldContent('style'); ?>
</head>

<body <?php if(auth()->user()->theme == 'dark'): ?> class="dark-theme" <?php endif; ?>>

    <!-- Loader -->
    <div id="global-loader">
        <img src="<?php echo e(asset('assets/back/img/loader.gif')); ?>" class="loader-img" alt="Loader">
    </div>
    <!-- End Loader -->
    <!-- Page -->
    <div class="page">
        <!-- Sidemenu -->
        <div class="main-sidebar main-sidebar-sticky side-menu">
            <div class="sidemenu-logo">
                <a class="main-logo" href="<?php echo e(url('admin')); ?>">
                    <img src="<?php echo e(config('site_logo')); ?>" alt="logo">
                </a>
            </div>

            <div class="main-sidebar-body">
                <ul class="nav">
                    <li class="nav-label"><?php echo e(trans('home.dashboard')); ?></li>

                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo e(url('/')); ?>" target="_blank"><i class="fe fe-airplay"></i><span
                                class="sidemenu-label"><?php echo e(__("home.main_page")); ?></span></a>
                    </li>

                    <li class="nav-item <?php if(Request::segment(2) == 'admin'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin')); ?>"><i class="fe fe-airplay"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.admin_index')); ?></span></a>
                    </li>


                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('website-content')): ?>
                    <li class="nav-label"><?php echo e(trans('home.website_content')); ?></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('subscribers')): ?>
                    <li class="nav-sub-item <?php if(Request::segment(2) == 'subscribers'): ?> active <?php endif; ?>">
                        <a class="nav-sub-link"
                            href="<?php echo e(route('subscribers.index')); ?>">   <i class="fas fa-users"></i> <?php echo e(trans('home.subscribers')); ?></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('requests')): ?>
                    <li
                        class="nav-item <?php if(Request::segment(2) == 'contact-messages' || Request::segment(2) == 'commercial-requests' ||  Request::segment(2) == 'inspection-requests' ): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-low-vision"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.requests')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('contact_messages')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'contact-messages'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('contact_messages.index')); ?>"><?php echo e(trans('home.contactUsMessages')); ?>

                                </a>
                                <?php if( $count = \App\Models\ContactUs::messageCount() > 0): ?>
                                <span class="badge badge-secondary side-badge"><?php echo e($count); ?></span>
                                <?php endif; ?>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('commercial_requests')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'commercial-requests'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('commercial_requests.index')); ?>"><?php echo e(trans('home.commercial_requests')); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('inspection_requests')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'inspection-requests'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('inspection_requests.index')); ?>"><?php echo e(trans('home.inspection_requests')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('menus')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'menus'): ?> active <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/menus')); ?>">
                            <i class="fas fa-envelope-open-text"></i>
                            <span class="sidemenu-label"> <?php echo e(trans('home.menus')); ?> </span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('sliders')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'home-sliders'): ?> active <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/sliders')); ?>">
                            <i class="fas fa-sliders-h"></i>
                            <span class="sidemenu-label"> <?php echo e(trans('home.sliders')); ?> </span>
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('site-addresses')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'site-addresses'): ?> active <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/site-addresses')); ?>">
                            <i class="fas fa-sliders-h"></i>
                            <span class="sidemenu-label"> <?php echo e(trans('home.site-addresses')); ?> </span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('about')): ?>
                    <li
                        class="nav-item <?php if(Request::segment(2) == 'editAbout' || Request::segment(2) == 'aboutStrucs'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-low-vision"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.about')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('editAbout')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'editAbout'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('about.edit')); ?>"><?php echo e(trans('home.editAbout')); ?></a>
                            </li>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('aboutStrucs')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'aboutStrucs'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(url('admin/aboutStrucs')); ?>"><?php echo e(trans('home.aboutStrucs')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('pages')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'pages'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/pages')); ?>"><i class="fas fa-file"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.pages')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('partners')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'partners'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(route('partners.index')); ?>"><i class="fe fe-box"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.partners')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('branches')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'branches'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(route('branches.index')); ?>"><i class="fe fe-branch"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.branches')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('store_info')): ?>
                    <li class="nav-label"><?php echo e(trans('home.store_info')); ?></li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('categories')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'categories'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/categories')); ?>">
                            <i class="fas fa-file"></i>
                            <span class="sidemenu-label"><?php echo e(trans('home.categories')); ?></span>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('attributes')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'attributes'): ?> active <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/attributes')); ?>">
                            <i class="fas fa-file"></i>
                            <?php echo e(trans('home.attributes')); ?>

                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('brands')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'brands'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/brands')); ?>"><i class="fas fa-copyright"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.brands')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('products')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'products'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/products')); ?>"><i class="fe fe-box"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.products')); ?></span></a>
                    </li>
                    <?php endif; ?>

                  

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('orders')): ?>
                    <li class="nav-label"><?php echo e(trans('home.orders')); ?></li>
                    <li class="nav-item <?php if(Request::segment(2) == 'orders'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/orders')); ?>">
                            <i class="fe fe-shopping-cart"></i>
                            <span class="sidemenu-label"><?php echo e(trans('home.orders')); ?></span>

                            <?php if(\App\Models\Order::orderCount() > 0): ?>
                                <span class="badge badge-success side-badge"><?php echo e(\App\Models\Order::orderCount()); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('simple_request_orders')): ?>
                    <li class="nav-label"><?php echo e(trans('home.orders')); ?></li>
                    <li class="nav-item <?php if(Request::segment(2) == 'orders'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(route('simple_request_orders.index')); ?>">
                            <i class="fe fe-shopping-cart"></i>
                            <span class="sidemenu-label"><?php echo e(trans('home.simple_request_orders')); ?></span>

                            <?php if(\App\Models\SimpleRequestOrder::count() > 0): ?>
                                <span class="badge badge-success side-badge"><?php echo e(\App\Models\SimpleRequestOrder::count()); ?></span>
                            <?php endif; ?>
                        </a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('reports')): ?>
                    <li class="nav-label"><?php echo e(trans('home.reports')); ?></li>
                    <li
                        class="nav-item <?php if(Request::segment(2) == 'order-report' || Request::segment(2) == 'daily-report' || Request::segment(2) == 'weekly-report' || Request::segment(2) == 'mothely-report'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-file"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.reports')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'order-report'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('reports.index')); ?>"><?php echo e(trans('home.order-report')); ?></a>
                            </li>

                            

                            <!--<li class="nav-sub-item <?php if(Request::segment(2) == 'weekly-report'): ?> active <?php endif; ?>">-->
                            <!--    <a class="nav-sub-link" href="<?php echo e(url('admin/weekly-report')); ?>"><?php echo e(trans('home.weekly_report')); ?></a>-->
                            <!--</li>-->

                        </ul>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('seo')): ?>
                    <li class="nav-label"><?php echo e(trans('home.seo')); ?></li>
                    <li class="nav-item <?php if(Request::segment(2) == 'seo-assistant'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/seo-assistant')); ?>"><i class="fas fa-search"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.seo_assistant')); ?></span></a>
                    </li>
                    <?php endif; ?>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings')): ?>
                    <li class="nav-label"><?php echo e(trans('home.Settings')); ?></li>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('countries')): ?>
                    <li
                        class="nav-item <?php if(Request::segment(2) == 'countries' || Request::segment(2) == 'Governorates' || Request::segment(2) == 'areas'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fe fe-map-pin"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.countries_and_Governorates')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('countries')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'countries'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(url('admin/countries')); ?>"><?php echo e(trans('home.countries')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('governorates')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'governorates'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(route('governorates.index')); ?>"><?php echo e(trans('home.governorates')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('areas')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'areas'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(url('admin/areas')); ?>"><?php echo e(trans('home.areas')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php endif; ?>

                    

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('payment-methods')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'payment-methods'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('admin/payment-methods')); ?>"><i
                                class="fas fa-money-bill-alt"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.paymentMethods')); ?></span></a>
                    </li>
                    <?php endif; ?>


                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                    <li
                        class="nav-item <?php if(Request::segment(2) == 'users' || Request::segment(2) == 'roles' || Request::segment(2) == 'permissions'|| Request::segment(2) == 'user-admins'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-users"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.users')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'users'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(url('admin/users')); ?>"><?php echo e(trans('home.users')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('admins')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'user-admins'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(url('admin/user-admins')); ?>"><?php echo e(trans('home.admins')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('roles')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'roles'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(url('admin/roles')); ?>"><?php echo e(trans('home.roles')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('permissions')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'permissions'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(url('admin/permissions')); ?>"><?php echo e(trans('home.permissions')); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <?php endif; ?>


                    <li
                        class="nav-item <?php if(Request::segment(2) == 'settings' || Request::segment(4) == 'en' || Request::segment(4) == 'ar'): ?> active show <?php endif; ?>">
                        <a class="nav-link with-sub" href=""><i class="fas fa-cogs"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.settings_and_configrations')); ?></span><i
                                class="angle fe fe-chevron-right"></i></a>
                        <ul class="nav-sub">
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('settings')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(2) == 'settings'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link" href="<?php echo e(url('admin/settings')); ?>"><?php echo e(trans('home.settings')); ?></a>
                            </li>
                            <?php endif; ?>

                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('configrations')): ?>
                            <li class="nav-sub-item <?php if(Request::segment(4) == 'en'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('configrations.edit','en')); ?>"><?php echo e(trans('home.configrations')); ?>

                                    <?php echo e(trans("home.en")); ?></a>
                            </li>
                            <li class="nav-sub-item <?php if(Request::segment(4) == 'ar'): ?> active <?php endif; ?>">
                                <a class="nav-sub-link"
                                    href="<?php echo e(route('configrations.edit','ar')); ?>"><?php echo e(trans('home.configrations')); ?>

                                    <?php echo e(trans("home.ar")); ?></a>
                            </li>
                            <?php endif; ?>
                        </ul>
                    </li>

                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('languages')): ?>
                    <li class="nav-item <?php if(Request::segment(2) == 'languages'): ?> active show <?php endif; ?>">
                        <a class="nav-link" href="<?php echo e(url('languages')); ?>" target="_blank"><i
                                class="fas fa-language"></i><span
                                class="sidemenu-label"><?php echo e(trans('home.site_translation')); ?></span></a>
                    </li>
                    <?php endif; ?>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
        <!-- End Sidemenu -->

        <!-- Main Content-->
        <div class="main-content side-content pt-0">
            <!-- Main Header-->
            <div class="main-header side-header sticky">
                <div class="container-fluid">
                    <div class="main-header-left">
                        <a class="main-logo d-lg-none" href="<?php echo e(LaravelLocalization::localizeUrl('/')); ?>">
                            <?php if(config('site_logo')): ?>
                            <img src="<?php echo e(config('site_logo')); ?>" alt="logo" width="70px"
                                height="70px">
                            <?php else: ?>
                            <img src="<?php echo e(config('site_logo')); ?>" alt="logo" width="70px"
                                height="70px">
                            <?php endif; ?>
                        </a>
                        <a class="main-header-menu-icon" href="" id="mainSidebarToggle"><span></span></a>
                    </div>

                    <div class="main-header-right">

                        <div class="arrow_box_right">
                            <?php if(app()->getLocale() == 'en'): ?>
                            <a href="<?php echo e(LaravelLocalization::getLocalizedURL('ar')); ?>" class="dropdown-item py-1">
                                <img src="<?php echo e(asset('assets/back/img/flags/eg.png')); ?>" alt="Arabic Flag"
                                    class="langimg" />
                            </a>
                            <?php else: ?>
                            <a href="<?php echo e(LaravelLocalization::getLocalizedURL('en')); ?>" class="dropdown-item py-1">
                                <img src="<?php echo e(asset('assets/back/img/flags/us.png')); ?>" alt="English Flag"
                                    class="langimg" />
                            </a>
                            <?php endif; ?>
                        </div>


                        <div class="dropdown d-md-flex">
                            <a class="nav-link icon full-screen-link">
                                <i class="fe fe-maximize fullscreen-button"></i>
                            </a>
                        </div>

                        <div class="dropdown main-profile-menu">
                            <a class="main-img-user" href="">
                                <?php if(auth()->user()->image): ?>
                                <img alt="avatar" src="<?php echo e(asset('assets/back/img/profile-user.png')); ?>">
                                <?php else: ?>
                                <img alt="avatar" src="<?php echo e(asset('assets/back/img/profile-user.png')); ?>">
                                <?php endif; ?>
                            </a>
                            <div class="dropdown-menu">
                                <div class="header-navheading">
                                    <h6 class="main-notification-title"><?php echo e(Auth::user()->name); ?></h6>
                                </div>

                                <a class="dropdown-item border-top" href="<?php echo e(url('user/account-settings')); ?>">
                                    <i class="fe fe-edit"></i>
                                    <?php echo e(trans('home.edit_profile')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(url('admin/switch-theme')); ?>">
                                    <i class="fas fa-palette"></i>
                                    <?php echo e(trans('home.switch_theme')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(url('admin/settings')); ?>">
                                    <i class="fe fe-settings"></i>
                                    <?php echo e(trans('home.settings')); ?>

                                </a>

                                <a class="dropdown-item" href="<?php echo e(route('logout')); ?>"
                                    onclick="event.preventDefault();document.getElementById('logout-form').submit();">
                                    <i class="fe fe-power"></i>
                                    <?php echo e(trans('home.log_out')); ?>

                                    <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST"
                                        style="display: none;">
                                        <?php echo e(csrf_field()); ?>

                                    </form>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- End Main Header-->

            

            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <!-- End Main Content-->

        <!-- Main Footer-->
        <div class="main-footer text-center">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <span> &copy; <?php echo e(date('Y')); ?> Developed and Designed by <a href="https://be-group.com/be_en"
                                target="_blank" class="active"> Be Group</a></span>
                    </div>
                </div>
            </div>
        </div>
        <!--End Footer-->
    </div>
    <!-- End Page -->

    <!-- Back-to-top -->
    <a href="#top" id="back-to-top"><i class="fe fe-arrow-up"></i></a>

    <!-- Jquery js-->
    <script src="<?php echo e(asset('assets/back/plugins/jquery/jquery.min.js')); ?>"></script>

    <!-- Bootstrap js-->
    <script src="<?php echo e(asset('assets/back/plugins/bootstrap/js/bootstrap.bundle.min.js')); ?>"></script>

    <!-- Ionicons js-->
    <script src="<?php echo e(asset('assets/back/plugins/ionicons/ionicons.js')); ?>"></script>

    <!-- Rating js-->
    <script src="<?php echo e(asset('assets/back/plugins/rating/jquery.rating-stars.js')); ?>"></script>

    <!-- Flot js-->
    <script src="<?php echo e(asset('assets/back/plugins/jquery.flot/jquery.flot.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/jquery.flot/jquery.flot.resize.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/js/chart.flot.sampledata.js')); ?>"></script>

    <!-- Chart.Bundle js-->
    <script src="<?php echo e(asset('assets/back/plugins/chart.js/Chart.bundle.min.js')); ?>"></script>

    <!-- Peity js-->
    <script src="<?php echo e(asset('assets/back/plugins/peity/jquery.peity.min.js')); ?>"></script>

    <!-- Jquery-Ui js-->
    <script src="<?php echo e(asset('assets/back/plugins/jquery-ui/ui/widgets/datepicker.js')); ?>"></script>

    <!-- Select2 js-->
    <script src="<?php echo e(asset('assets/back/plugins/select2/js/select2.min.js')); ?>"></script>

    <!-- Data Table js -->
    <script src="<?php echo e(asset('assets/back/plugins/datatable/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/js/table-data.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/datatable/fileexport/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/js/new-tinymce/tinymce.min.js')); ?>"></script>

    <!---Fileupload css-->
    <script src="<?php echo e(asset('assets/back/plugins/fileuploads/js/fileupload.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/fileuploads/js/file-upload.js')); ?>"></script>

    <!--Fancy uploader js-->
    <script src="<?php echo e(asset('assets/back/plugins/fancyuploder/jquery.ui.widget.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/fancyuploder/jquery.fileupload.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/fancyuploder/jquery.iframe-transport.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/fancyuploder/jquery.fancy-fileupload.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/fancyuploder/fancy-uploader.js')); ?>"></script>

    <!---Select2 js-->
    <script src="<?php echo e(asset('assets/back/plugins/select2/js/select2.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/js/select2.js')); ?>"></script>

    <!-- Jquery.mCustomScrollbar js-->
    <script
        src="<?php echo e(asset('assets/back/plugins/jquery.mCustomScrollbar/jquery.mCustomScrollbar.concat.min.js')); ?>">
    </script>

    <!-- Perfect-scrollbar js-->
    <script src="<?php echo e(asset('assets/back/plugins/perfect-scrollbar/perfect-scrollbar.min.js')); ?>"></script>

    <!-- Sidemenu js-->
    <script src="<?php echo e(asset('assets/back/plugins/sidemenu/sidemenu.js')); ?>"></script>

    <!-- Sidebar js-->
    <?php if(app()->getLocale() == 'en'): ?>
    <script src="<?php echo e(asset('assets/back/plugins/sidebar/sidebar.js')); ?>"></script>
    <?php else: ?>
    <script src="<?php echo e(asset('assets/back/plugins/sidebar/sidebar-rtl.js')); ?>"></script>
    <?php endif; ?>

    <!-- Sticky js-->
    <script src="<?php echo e(asset('assets/back/js/sticky.js')); ?>"></script>

    <!-- Dashboard js-->
    <script src="<?php echo e(asset('assets/back/js/index.js')); ?>"></script>

    <!-- Custom js-->
    <script src="<?php echo e(asset('assets/back/js/custom.js')); ?>"></script>

    <!-- Gallery js-->
    <script src="<?php echo e(asset('assets/back/plugins/gallery/picturefill.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lightgallery.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lightgallery-1.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-pager.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-autoplay.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-fullscreen.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-zoom.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-hash.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/back/plugins/gallery/lg-share.js')); ?>"></script>
    <script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.10.3/jquery-ui.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script>
        toastr.options = {
                "timeOut": "10000", // Time in milliseconds before hiding (10 seconds)
                "extendedTimeOut": "2000", // Time in milliseconds for hover pause
                "closeButton": true, // Adds a close button
                "progressBar": true, // Adds a progress bar
            };
             var lang = "<?php echo e(app()->getLocale()); ?>";
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                    'lang' : lang,
                }
            });
    </script>
    <script>
        <?php if($errors->any()): ?>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    toastr.error('<?php echo e($error); ?>');
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>

            <?php if(session()->has('success')): ?>
                <?php if(is_array(session('success'))): ?>
                    <?php $__currentLoopData = session('success'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $message): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        toastr.success('<?php echo e($message); ?>');
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                    toastr.success('<?php echo e(session('success')); ?>');
                <?php endif; ?>
            <?php endif; ?>
    </script>
    <?php echo $__env->yieldContent('script'); ?>

    <script>
        ///////// HTML editor ////////////////
            const useDarkMode = window.matchMedia('(prefers-color-scheme: dark)').matches;
            const isSmallScreen = window.matchMedia('(max-width: 1023.5px)').matches;
            texteara = $('textarea.area1') ;
            if(texteara.length){
                tinymce.init({
                    selector: 'textarea.area1',
                    plugins: 'preview importcss searchreplace autolink autosave save directionality code visualblocks visualchars fullscreen image link media template codesample table charmap pagebreak nonbreaking anchor insertdatetime advlist lists wordcount help charmap quickbars emoticons',
                    editimage_cors_hosts: ['picsum.photos'],
                    menubar: 'file edit view insert format tools table help',
                    toolbar: 'undo redo | bold italic underline strikethrough | fontfamily fontsize blocks | alignleft aligncenter alignright alignjustify | outdent indent |  numlist bullist | forecolor backcolor removeformat | pagebreak | charmap emoticons | fullscreen  preview save print | insertfile image media template link anchor codesample | ltr rtl',
                    toolbar_sticky: true,
                    toolbar_sticky_offset: isSmallScreen ? 102 : 108,
                    autosave_ask_before_unload: true,
                    autosave_interval: '30s',
                    autosave_prefix: '{path}{query}-{id}-',
                    autosave_restore_when_empty: false,
                    autosave_retention: '2m',
                    image_advtab: true,
                    link_list: [
                        { title: 'My page 1', value: 'https://www.tiny.cloud' },
                        { title: 'My page 2', value: 'http://www.moxiecode.com' }
                    ],
                    image_list: [
                        { title: 'My page 1', value: 'https://www.tiny.cloud' },
                        { title: 'My page 2', value: 'http://www.moxiecode.com' }
                    ],
                    image_class_list: [
                        { title: 'None', value: '' },
                        { title: 'Some class', value: 'class-name' }
                    ],
                    importcss_append: true,
                    file_picker_callback: (callback, value, meta) => {
                        /* Provide file and text for the link dialog */
                        if (meta.filetype === 'file') {
                        callback('https://www.google.com/logos/google.jpg', { text: 'My text' });
                        }

                        /* Provide image and alt text for the image dialog */
                        if (meta.filetype === 'image') {
                        callback('https://www.google.com/logos/google.jpg', { alt: 'My alt text' });
                        }

                        /* Provide alternative source and posted for the media dialog */
                        if (meta.filetype === 'media') {
                        callback('movie.mp4', { source2: 'alt.ogg', poster: 'https://www.google.com/logos/google.jpg' });
                        }
                    },
                    templates: [
                        { title: 'New Table', description: 'creates a new table', content: '<div class="mceTmpl"><table width="98%%"  border="0" cellspacing="0" cellpadding="0"><tr><th scope="col"> </th><th scope="col"> </th></tr><tr><td> </td><td> </td></tr></table></div>' },
                        { title: 'Starting my story', description: 'A cure for writers block', content: 'Once upon a time...' },
                        { title: 'New list with dates', description: 'New List with dates', content: '<div class="mceTmpl"><span class="cdate">cdate</span><br><span class="mdate">mdate</span><h2>My List</h2><ul><li></li><li></li></ul></div>' }
                    ],
                    template_cdate_format: '[Date Created (CDATE): %m/%d/%Y : %H:%M:%S]',
                    template_mdate_format: '[Date Modified (MDATE): %m/%d/%Y : %H:%M:%S]',
                    height: 600,
                    image_caption: true,
                    quickbars_selection_toolbar: 'bold italic | quicklink h2 h3 blockquote quickimage quicktable',
                    noneditable_class: 'mceNonEditable',
                    toolbar_mode: 'sliding',
                    contextmenu: 'link image table',
                    skin: useDarkMode ? 'oxide-dark' : 'oxide',
                    content_css: useDarkMode ? 'dark' : 'default',
                    content_style: 'body { font-family:Helvetica,Arial,sans-serif; font-size:16px }'
                });
            }


            ///////// MAPS with lat and long//////
            var lat = $('#latitude').val();
            var long = $('#longitude').val();

            if(lat != ''){
                function initMap2() {
                        var uluru = {lat: Number(lat), lng: Number(long)};
                        var myOptions = {
                            zoom: 15,
                            center: new google.maps.LatLng(lat, long)
                        },
                        map = new google.maps.Map(document.getElementById('map-canvas'), myOptions),
                        marker = new google.maps.Marker({
                            position: uluru,
                            map: map,
                        }),
                        infowindow = new google.maps.InfoWindow;
                        map.addListener('click', function(e) {
                        map.setCenter(e.latLng);
                        marker.setPosition(e.latLng);
                        infowindow.setContent("Latitude: " + e.latLng.lat() +
                            "<br>" + "Longitude: " + e.latLng.lng());
                        infowindow.open(map, marker);
                        var s = $('#latitude').val(e.latLng.lat());
                        var ss = $('#longitude').val(e.latLng.lng());
                    });
                }
            }else{
                function initMap1() {
                    var uluru = {lat: 30.0561, lng: 31.2394};
                    var myOptions = {
                            zoom: 10,
                            center: new google.maps.LatLng(30.0561, 31.2394)
                        },
                        map = new google.maps.Map(document.getElementById('map-canvas'), myOptions),
                        marker = new google.maps.Marker({
                            position: uluru,
                            map: map,
                        }),
                        infowindow = new google.maps.InfoWindow;
                    map.addListener('click', function(e) {
                        map.setCenter(e.latLng);
                        marker.setPosition(e.latLng);
                        infowindow.setContent("Latitude: " + e.latLng.lat() +
                            "<br>" + "Longitude: " + e.latLng.lng());
                        infowindow.open(map, marker);
                        var s = $('#latitude').val(e.latLng.lat());
                        var ss = $('#longitude').val(e.latLng.lng());
                    });
                }
            }



            $( "form" ).submit(function() {
                $('#loader').show();
            });


            ///////check All adata table//////

            if(lang == "ar"){
                var table = $('#exportexample').DataTable( {
                    lengthChange: false,
                    dom: 'Bfrtip',
                    "pageLength": 50,
                    buttons: [ 'copy', 'excel', 'colvis' ],
                    order: false ,
                    language: {
                        url: '//cdn.datatables.net/plug-ins/1.13.3/i18n/ar.json',
                    },
                } );
            }else{
                var table = $('#exportexample').DataTable( {
                    lengthChange: false,
                    dom: 'Bfrtip',
                    "pageLength": 50,
                    ordering: false, // Disable all ordering functionality
                    buttons: [ 'copy', 'excel', 'colvis' ],
                } );
            }

            $("#checkAll").change(function () {
                $("input:checkbox").prop('checked', $(this).prop("checked"));
            });

            $(".checkAll").change(function () {
                $(".web").prop('checked', $(this).prop("checked"));
            });

            $(".checkAllcart").change(function () {
                $(".cart").prop('checked', $(this).prop("checked"));
            });

            <?php
                $segment = Request::segment(3) ;
            ?>
            var url = <?php echo json_encode(url("admin/$segment"), 15, 512) ?>

            var segment = <?php echo json_encode(Request::segment(3), 15, 512) ?>;
            //// btn_delete ////
            $(document).ready(function(){
                // delete pulk of itmes
                $('#btn_delete').click(function(){
                    var id = [];
                    $('.tableChecked:checked').each(function(i){
                        id[i] = $(this).val();
                    });
                    if ( id.length > 0 && id[0] == 'a11') {
                        id.shift()
                    }
                    if(id.length === 0) //tell you if the array is empty
                    {
                        Swal.fire({
                            title: "<?php echo app('translator')->get('home.select'); ?>?",
                            text: "<?php echo app('translator')->get('home.please select at least one'); ?>",
                            icon: "question"
                        });
                    }else{

                        Swal.fire({
                            title: "<?php echo app('translator')->get('home.are you sure?'); ?>",
                            text: "<?php echo app('translator')->get('home.remove checked values'); ?>",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "<?php echo app('translator')->get('home.yes, delete it'); ?>!"
                            }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url:url+'/'+id[0],
                                    type:'DELETE',
                                    data:{id:id},
                                    success:function(res)
                                    {
                                        for(var i=0; i<id.length; i++)
                                        {
                                            $('tr#'+id[i]+'').css('background-color', '#ccc');
                                            $('tr#'+id[i]+'').fadeOut('slow');
                                            $('input[type="checkbox"]').prop('checked', false);
                                            Swal.fire({
                                                title: "Deleted!",
                                                text: res.message,
                                                icon: "success"
                                            });
                                        }
                                    },
                                    error:function (error) {
                                        Swal.fire({
                                            title: "Error!",
                                            text: error.responseJSON.message,
                                            icon: "error"
                                        });
                                    }
                                });
                            }
                        });
                    }
                });

                // change status pulk of items

                $('#btn_active').click(function(){
                    let selectedIds = [];
                    $('.tableChecked:checked').each(function(i){
                        selectedIds[i] = $(this).val();
                    });

                    if ( selectedIds.length > 0 && selectedIds[0] == 'a11') {
                        selectedIds.shift()
                    }

                    if(selectedIds.length === 0) {
                        Swal.fire({
                            title: "<?php echo app('translator')->get('home.select'); ?>?",
                            text: "<?php echo app('translator')->get('home.please select at least one'); ?>",
                            icon: "question"
                        });
                    }else{
                        Swal.fire({
                            title: "<?php echo app('translator')->get('home.are you sure?'); ?>",
                            text: "<?php echo app('translator')->get('home.change status checked values'); ?>!",
                            icon: "warning",
                            showCancelButton: true,
                            confirmButtonColor: "#3085d6",
                            cancelButtonColor: "#d33",
                            confirmButtonText: "<?php echo app('translator')->get('home.yes, change it'); ?>!"
                        }).then((result) => {
                            if (result.isConfirmed) {
                                $.ajax({
                                    url: url + "/change-status" + '/' + selectedIds,
                                    method:'POST',
                                    data:{
                                        selectedIds:selectedIds,
                                        modelName:segment
                                    },
                                    success:function(res)
                                    {
                                        for (let i = 0; i < selectedIds.length; i++) {
                                            $('tr#' + selectedIds[i]).find('.status').each(function(_, element) {


                                                var currentValue = $(element).text().trim();
                                                var newValue = currentValue === "<?php echo e(__('home.yes')); ?>" ? "<?php echo e(__('home.no')); ?>" : "<?php echo e(__('home.yes')); ?>";
                                                console.log(element,currentValue,newValue);
                                                $(element).text(newValue); // Update the element with the new value
                                            });
                                        }
                                        Swal.fire({
                                            title: "<?php echo app('translator')->get('home.chenged'); ?>!",
                                            text: res.message,
                                            icon: "success"
                                        });
                                        $('input:checkbox').removeAttr('checked');
                                        // location.reload();
                                    }
                                });
                            }
                        });
                    }
                });
            });
    </script>

<script>
    document.addEventListener('DOMContentLoaded', function () {
        const deleteButtons = document.querySelectorAll('.btn-delete-form');

        deleteButtons.forEach(button => {
            button.addEventListener('click', function (e) {
                e.preventDefault();

                const form = this.closest('form');

                Swal.fire({
                    title: '<?php echo e(__("Are you sure?")); ?>',
                    text: '<?php echo e(__("This action cannot be undone.")); ?>',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: '<?php echo e(__("Yes, delete it!")); ?>',
                    cancelButtonText: '<?php echo e(__("Cancel")); ?>',
                }).then((result) => {
                    if (result.isConfirmed) {
                        form.submit();
                    }
                });
            });
        });
    });
</script>


      <script>
        document.getElementById('apply_to_select').addEventListener('change', function () {
            const wrapper = document.getElementById('variant_ids_wrapper');
            wrapper.style.display = this.value === 'variant' ? 'block' : 'none';
        });
    </script>




</body>

</html><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/layouts/admin.blade.php ENDPATH**/ ?>