<title><?php echo e(trans('home.orders')); ?></title>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.orders')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.orders')); ?></li>
            </ol>
        </div>

<div class="btn btn-list">

    

    <a href="#" class="btn ripple btn-secondary navresponsive-toggler mb-0" data-toggle="collapse" data-target="#navbarSupportedContent" aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
        <i class="fe fe-filter mr-1"></i> <?php echo e(trans('home.filter')); ?> <i class="fas fa-caret-down ml-1"></i>
    </a>

</div>
</div>
<!-- End Page Header -->

<form action="<?php echo e(url()->current()); ?>" method="get">
    <div class="responsive-background">
        <div class="collapse navbar-collapse" id="navbarSupportedContent">
            <div class="advanced-search">
                <div class="row align-items-center">

                    <div class="form-group col-md-4">
                        <label for="code"><?php echo e(trans('home.from')); ?></label>
                        <div class="input-group">
                            <input type='date' class="form-control" name="from" placeholder="<?php echo e(trans('home.to')); ?>" />

                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="code"><?php echo e(trans('home.to')); ?></label>
                        <div class="input-group">
                            <input type='date' class="form-control dateFrom" name="to" placeholder="<?php echo e(trans('home.to')); ?>" />
                            <div class="input-group-append">
                                <span class="input-group-text">
                                    <i class="fas fa-calendar"></i>
                                </span>
                            </div>
                        </div>
                    </div>

                    <div class="form-group col-md-4">
                        <label for="helperText"><?php echo e(trans('home.order_status')); ?></label>
                        <select class="form-control select2" name="order_status" id="order-status">
                            <option></option>
                            <option value="pending"><?php echo e(trans('home.pending')); ?></option>
                            <option value="accept"><?php echo e(trans('home.accept')); ?></option>
                            <option value="process"><?php echo e(trans('home.process')); ?></option>
                            <option value="shipping"><?php echo e(trans('home.shipping')); ?></option>
                            <option value="delivered"><?php echo e(trans('home.delivered')); ?></option>
                            <option value="canceled"><?php echo e(trans('home.canceled')); ?></option>
                        </select>
                    </div>
                </div>
                <hr>
                <div class="text-right">
                    <button type="submit" class="btn btn-primary "><?php echo e(trans('home.applay')); ?></button>
                    <a href="<?php echo e(url()->current()); ?>" class="btn btn-secondary"><?php echo e(trans('home.reset')); ?></a>
                </div>
            </div>
        </div>
    </div>
</form>
<!-- Row-->
<div class="row">
    <div class="col-sm-12 col-xl-12 col-lg-12">

        <div class="card custom-card overflow-hidden">
            <div class="card-body">
                <div class="filter-result">
                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.orders')); ?></h6>
                        <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                    </div>
                    <div class="table-responsive">
                        <table class="table" id="exportexample" data-order='[[ 1, "desc" ]]'>
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo e(__('home.id')); ?></th>
                                    <th><?php echo e(trans('home.order_number')); ?></th>
                                    <th><?php echo e(trans('home.order_date')); ?></th>
                                    <th><?php echo e(trans('home.order_user')); ?></th>
                                    <th><?php echo e(__('home.customer_status')); ?></th>
                                    <th><?php echo e(__('home.Email Address')); ?></th>
                                    <th><?php echo e(trans('home.order_phone_numbers')); ?></th>
                                    <th><?php echo e(__('home.total')); ?></th>
                                    <th><?php echo e(__('home.products')); ?></th>
                                    <th><?php echo e(trans('home.order_address')); ?></th>
                                    <th><?php echo e(trans('home.order_status')); ?></th>
                                    <th><?php echo e(trans('home.payment_status')); ?></th>
                                    <th><?php echo e(trans('home.payment_method')); ?></th>
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_order')): ?>
                                    <th>Delete</th>
                                    <?php endif; ?>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                             
                                <tr>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($key+1); ?></a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->id); ?></a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->order_number); ?></a></td>
                                    <td><?php echo e(date('Y-m-d', strtotime($order->created_at ))); ?></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->user->f_name.' '.$order->user->l_name); ?></a></td>
                                    <td>
                                        <?php if($order->is_first_order): ?>
                                        <span class="badge badge-success"><?php echo e(__('home.first_time')); ?></span>
                                        <?php else: ?>
                                        <span class="badge badge-warning"><?php echo e(__('home.repeat_customer')); ?></span>
                                        <?php endif; ?>
                                        <br> <br>
                                        <small><?php echo e(__('home.total_orders')); ?>: <?php echo e($order->total_orders_by_phone); ?></small>
                                    </td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->user->email); ?></a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->address?->phone ?? trans('home.unknown_phone')); ?> </a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->total_amount .' ' . config('app.currency')); ?> </a></td>
                                    <!-- NEW PRODUCTS COLUMN -->
                                    <td>
                                        <?php if($order->items && $order->items->count()): ?>
                                        <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div>
                                            <?php echo e($item->product->name); ?> (Qty: <?php echo e($item->product->quantity); ?>, Price: <?php echo e($item->product->price); ?>)
                                        </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                        <span><?php echo e(__('home.no_products')); ?></span>
                                        <?php endif; ?>
                                    </td>

                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->full_address ?? trans('home.unknown_address')); ?></a></td>

                                    <td>
                                        <?php if($order->status_name == 'Pending'): ?>
                                        <span class="badge badge-primary"><?php echo e(trans('home.pending')); ?></span>
                                        <?php elseif($order->status_name == 'Processing'): ?>
                                        <span class="badge badge-secondary"><?php echo e(trans('home.Processing')); ?></span>
                                        <?php elseif($order->status_name == 'Confirmed'): ?>
                                        <span class="badge badge-info"><?php echo e(trans('home.Confirmed')); ?></span>
                                        <?php elseif($order->status_name == 'Shipped'): ?>
                                        <span class="badge badge-default"><?php echo e(trans('home.Shipped')); ?></span>
                                        <?php elseif($order->status_name == 'Out for Delivery'): ?>
                                        <span class="badge badge-success"><?php echo e(trans('home.Out for Delivery')); ?></span>
                                        <?php elseif($order->status_name == 'Delivered'): ?>
                                        <span class="badge badge-success"><?php echo e(trans('home.delivered')); ?></span>
                                        <?php elseif($order->status_name == 'Cancelled'): ?>
                                        <span class="badge badge-danger"><?php echo e(trans('home.canceled')); ?></span>
                                        <?php elseif($order->status_name == 'Refunded'): ?>
                                        <span class="badge badge-danger"><?php echo e(trans('home.Refunded')); ?></span>
                                        <?php elseif($order->status_name == 'Failed'): ?>
                                        <span class="badge badge-danger"><?php echo e(trans('home.Refunded')); ?></span>
                                        <?php elseif($order->status_name == 'On Hold'): ?>
                                        <span class="badge badge-danger"><?php echo e(trans('home.On Hold')); ?></span>
                                        <?php endif; ?>

                                    </td>
                                   
                                    <?php if($order->payment?->status == 'paid'): ?>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e(__('home.paid')); ?> </a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->payment->paymentMethod?->name); ?></a></td>
                                    <?php else: ?>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e(__('home.unpaid')); ?> </a></td>
                                    <td><a href="<?php echo e(route('orders.edit', $order->id)); ?>"><?php echo e($order->payment?->paymentMethod?->name); ?></a></td>
                                    <?php endif; ?>

                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('delete_order')): ?>
                                    <td>
                                        <form action="<?php echo e(route('orders.destroy',$order->id)); ?>" method="POST">
                                            <?php echo csrf_field(); ?>
                                            <?php echo method_field('DELETE'); ?>
                                            <button type="submit" class="btn btn-danger btn-sm delete" data-toggle="modal" data-target="#deleteModal"><i class="fas fa-trash"></i></button>
                                        </form>
                                    </td>
                                    <?php endif; ?>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<!-- End Row -->
</div>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('script'); ?>
<script>
    $(document).on({
        ajaxStart: function() {
            $('#loader').show();
        }
        , ajaxStop: function() {
            $('#loader').hide();
        }
    });

    $('.order-filter').on('click', function() {
        var dateFrom = $('.dateFrom').val();
        var dateTo = $('.dateTo').val();
        var status = $('#order-status option:selected').val();

        if (dateFrom && dateTo) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: " <?php echo e(url('admin/orders/filter')); ?>"
                , method: 'POST'
                , data: {
                    dateFrom: dateFrom
                    , dateTo: dateTo
                    , status: status
                }
                , success: function(html) {
                    $('.filter-result').html(html.html);
                }
            });
        } else {
            alert("<?php echo e(trans('home.Please Select Date From And Date To')); ?>");
        }
    });

    $('.reset').click(function() {
        $('input[type="text"]').val('');
        $('select').val('').trigger('change');;
    });

    $("#datepicker1").datepicker({
        changeMonth: true
        , changeYear: true
        , dateFormat: 'yy-mm-dd'
    });

    $("#datepicker2").datepicker({
        changeMonth: true
        , changeYear: true
        , dateFormat: 'yy-mm-dd'
    });

</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/orders/orders.blade.php ENDPATH**/ ?>