<div class="row">
    <div class="col-sm-12 col-xl-12 col-lg-12">
        <div class="card custom-card overflow-hidden">
            <div class="card-body">
                <form action="<?php echo e(route('products.discounts.store', $product->id)); ?>" method="post">
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.name')); ?></label>
                            <input class="form-control" name="name" type="text"
                                   placeholder="Discount name like 'Summer Sale', 'Black Friday'" value="<?php echo e(old('name')); ?>">
                        </div>

                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.type')); ?></label>
                            <select class="form-control" name="type">
                                <?php $__currentLoopData = App\Models\ProductDiscount::TYPES; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type); ?>" <?php if(old('type') == $type): echo 'selected'; endif; ?>><?php echo e($type); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.value')); ?></label>
                            <input class="form-control" name="value" step="0.01" type="number"
                                   placeholder="<?php echo e(trans('home.value')); ?>" value="<?php echo e(old('value')); ?>">
                        </div>

                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.apply_to')); ?></label>
                            <select name="apply_to" class="form-control" id="apply_to_select">
                                <option value="product" <?php if(old('apply_to') == 'product'): echo 'selected'; endif; ?>><?php echo e(__('home.product')); ?></option>
                                <?php if($product->has_variants): ?>
                                      <option value="variant" <?php if(old('apply_to') == 'variant'): echo 'selected'; endif; ?>><?php echo e(__('home.variant')); ?></option>
                                <?php endif; ?>

                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-3" id="variant_ids_wrapper" style="display: <?php echo e(old('apply_to') == 'variant' ? 'block' : 'none'); ?>;">
                            <label><?php echo e(__('home.select_variants')); ?></label>
                            <select name="variant_id" class="form-control">
                                <option value="">Select Variant</option>
                                <?php $__currentLoopData = $product->variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($variant->id); ?>" <?php if(old('variant_id') == $variant->id): echo 'selected'; endif; ?>>
                                    <?php $__currentLoopData = $variant->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variantValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <span class="badge badge-primary"><?php echo e($variantValue->value->value); ?></span>
                                       <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </option>

                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>



                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.start_date')); ?></label>
                            <input class="form-control" name="starts_at" type="date"
                                   value="<?php echo e(old('starts_at')); ?>">
                        </div>

                        <div class="form-group col-md-3">
                            <label><?php echo e(trans('home.end_date')); ?></label>
                            <input class="form-control" name="expires_at" type="date"
                                   value="<?php echo e(old('expires_at')); ?>">
                        </div>

                        <div class="form-group col-md-3">
                            <label>Is Active</label>
                            <input type="checkbox" id="switch1" switch="none" value="1" name="is_active" <?php echo e(old('is_active', true) ? 'checked' : ''); ?> />

                        </div>


                    </div>

                    <div class="row">
                        <div class="form-group col-md-12">
                            <button type="submit" class="btn btn-success"> <?php echo e(trans('home.save')); ?> </button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/products/discounts/create.blade.php ENDPATH**/ ?>