<title><?php echo e(trans('home.add_branche')); ?></title>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.branches')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(route('branches.index')); ?>"><?php echo e(trans('home.branches')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.add_branche')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.add_branche')); ?></h6>
                        </div>
                        <form action="<?php echo e(route('branches.store')); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <div class="row">

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>">
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>">
                                </div>
                                
                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.address_en')); ?></label>
                                    <input class="form-control" name="address_en" type="text" placeholder="<?php echo e(trans('home.address_en')); ?>" />
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.address_ar')); ?></label>
                                    <input class="form-control" name="address_ar" type="text" placeholder="<?php echo e(trans('home.address_ar')); ?>"/>
                                </div>

                                <div class="form-group col-md-3">
                                    <label for="inputName4"><?php echo e(trans('home.governorates')); ?>:</label>
                                    <select class="form-control Governorate select2" name="governorate_id">
                                        <option value="null"><?php echo e(__('home.select_governorate')); ?></option>
                                        <?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($governorate->id); ?>"> <?php echo e($governorate->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.phone')); ?></label>
                                    <input class="form-control" name="phone" type="number" min="0" placeholder="<?php echo e(trans('home.phone')); ?>">
                                </div>
                                
                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.phone')); ?> 2</label>
                                    <input class="form-control" name="phone2" type="number" min="0" placeholder="<?php echo e(trans('home.phone')); ?> 2">
                                </div>

                                <div class="form-group col-md-3">
                                    <label class=""><?php echo e(trans('home.telephone')); ?></label>
                                    <input class="form-control" name="telephone" type="number" min="0" placeholder="<?php echo e(trans('home.telephone')); ?>">
                                </div>
                                
                                <div class="col-md-12">
                                    <label><?php echo e(trans('home.map_url')); ?></label>
                                    <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"></textarea>
                                </div>

                                <div class="form-group col-md-12 mt-3">
                                    <label class="ckbox">
                                        <input name="status" value="1" type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(route('branches.index')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>
                                
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>
        $('.Governorate').select2({
            'placeholder':'<?php echo e(trans("home.Governorates")); ?>'
        });

        $('.area').select2({
            'placeholder':'<?php echo e(trans("home.areas")); ?>'
        });

        $('.Governorate').change(function () {
            var id = $(this).val();
            var area = $('.area');
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                type: "POST",
                url: '<?php echo e(url('getAreas')); ?>',
                data: {id: id},
                success: function( data ) {
                    var html = '';
                    html += '<option></option>'
                    for(var i=0;i<data.length;i++){
                        html += '<option  value="'+ data[i].id +'"><?php if(\App::getLocale() == 'en'): ?>'+ data[i].name_en +' <?php else: ?> '+ data[i].name_ar +' <?php endif; ?></option>';
                    }
                    area.html(html);
                }
            });
        });
    
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/branches/create.blade.php ENDPATH**/ ?>