<?php $__env->startSection('meta'); ?>
<title><?php echo e(trans('home.edit_category')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>

<div class="container-fluid">

        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.categories')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item"><a href="<?php echo e(url('admin/categories')); ?>"><?php echo e(trans('home.categories')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_category')); ?></li>
                </ol>
            </div>
        </div>
        <!-- End Page Header -->

        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">
                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.edit_category')); ?></h6>
                        </div>
                       <form method="post" action="<?php echo e(route('categories.update', $category->id)); ?>" enctype="multipart/form-data">
                        <?php echo method_field('PUT'); ?>
                        <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.name_en')); ?></label>
                                    <input class="form-control" name="name_en" type="text" placeholder="<?php echo e(trans('home.name_en')); ?>"  value="<?php echo e($category->name_en); ?>" required>
                                </div>
                                <div class="form-group col-md-4">
                                    <label class=""><?php echo e(trans('home.name_ar')); ?></label>
                                    <input class="form-control" name="name_ar" type="text" placeholder="<?php echo e(trans('home.name_ar')); ?>" value="<?php echo e($category->name_ar); ?>" required>
                                </div>
                                <div class="form-group col-md-3">
                                    <label for="parent"><?php echo e(trans('home.parent')); ?></label>
                                    <select class="form-control select2" name="parent_id">
                                        <option value="null" <?php echo e(!old('parent_id') ? 'selected' : ''); ?>><?php echo e(trans('home.no_parent')); ?></option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categ): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($categ->id); ?>" <?php echo e(($categ->id == $category->parent_id)?'selected':''); ?>><?php echo e((app()->getLocale()=='en')? $categ->name_en:$categ->name_ar); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                 <div class="form-group col-md-1">
                                    <label class=""><?php echo e(trans('home.order')); ?></label>
                                    <input class="form-control" name="order" type="number" min="0" placeholder="<?php echo e(trans('home.order')); ?>" value="<?php echo e($category->order); ?>">
                                </div>

                                <div class="col-md-6">
                                    <label><?php echo e(trans('home.image')); ?> (225px  * 225px max 1mb)</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="image">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_image')); ?></label>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <label><?php echo e(trans('home.icon')); ?> (50px  * 50px max 1mb)</label>
                                    <div class="input-group mb-1">
                                        <div class="input-group-prepend">
                                            <span class="input-group-text"> <?php echo e(trans('home.upload')); ?></span>
                                        </div>
                                        <div class="custom-file">
                                            <input type="file" class="custom-file-input" name="icon">
                                            <label class="custom-file-label" for="inputGroupFile01"><?php echo e(trans('home.choose_icon')); ?></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="row col-12">
                                    <div class="col-md-6">
                                        <?php if($category->image): ?>
                                            <img src="<?php echo e($category->image_path); ?>" width="150">
                                        <?php endif; ?>
                                    </div>

                                    <div class="col-md-6">
                                        <?php if($category->icon): ?>
                                            <img src="<?php echo e($category->icon_path); ?>" width="150">
                                        <?php endif; ?>
                                    </div>
                                </div>
                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.desc_en')); ?></label>
                                    <textarea class="form-control area1" name="text_en" type="text" placeholder="<?php echo e(trans('home.desc_en')); ?>" ><?php echo e($category->desc_en); ?></textarea>
                                </div>

                                <div class="form-group col-md-6">
                                    <label class=""><?php echo e(trans('home.desc_ar')); ?></label>
                                    <textarea class="form-control area1" name="text_ar" type="text" placeholder="<?php echo e(trans('home.desc_ar')); ?>"><?php echo e($category->desc_ar); ?></textarea>
                                </div>

                                <div class="form-group col-md-12">
                                    <label class="ckbox">
                                        <input name="status" value="1" <?php echo e(($category->status == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.publish')); ?></span>
                                    </label>
                                </div>

                                <div class="col-12">
                                    <div class="row">
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.en')); ?></span>
                                        </div>

                                        <div class="form-group col-md-2">
                                            <label for="name_ar"><?php echo e(trans('home.link_en')); ?></label>
                                            <input type="text" autocomplete="off"  class="form-control" placeholder="<?php echo e(trans('home.link')); ?>" name="link_en" value="<?php echo e($category->link_en); ?>">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title_en')); ?></label>
                                            <textarea class="form-control" name="meta_title_en" placeholder="<?php echo e(trans('home.meta_title_en')); ?>"><?php echo e($category->meta_title_en); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc_en')); ?></label>
                                            <textarea class="form-control" name="meta_description_en" placeholder="<?php echo e(trans('home.meta_desc_en')); ?>"><?php echo e($category->meta_description_en); ?></textarea>
                                        </div>
                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                        </div>
                                        <div class="form-group col-md-2">
                                            <label for="name_ar"><?php echo e(trans('home.link_ar')); ?></label>
                                            <input type="text" autocomplete="off"  class="form-control" placeholder="<?php echo e(trans('home.link_ar')); ?>" name="link_ar" value="<?php echo e($category->link_ar); ?>">
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_title"> <?php echo e(trans('home.meta_title_ar')); ?></label>
                                            <textarea class="form-control" name="meta_title_ar" placeholder="<?php echo e(trans('home.meta_title_ar')); ?>"><?php echo e($category->meta_title_ar); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-5">
                                            <label for="meta_desc"> <?php echo e(trans('home.meta_desc_ar')); ?></label>
                                            <textarea class="form-control" name="meta_description_ar" placeholder="<?php echo e(trans('home.meta_desc_ar')); ?>"><?php echo e($category->meta_description_ar); ?></textarea>
                                        </div>

                                        <div class="form-group col-md-12">
                                            <hr>
                                            <span class="badge badge-success"><?php echo e(trans('home.ar')); ?></span>
                                        </div>


                                        <div class="form-group col-md-12">
                                            <label class="ckbox">
                                                <input name="index" value="1" <?php echo e(($category->index == 1)? 'checked':''); ?> type="checkbox"><span class="tx-13"><?php echo e(trans('home.meta_robots')); ?> (index)</span>
                                            </label>
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group col-md-12">
                                    <button type="submit" class="btn btn-success"><i class="icon-note"></i> <?php echo e(trans('home.save')); ?> </button>
                                    <a href="<?php echo e(url('/admin/categories')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/categories/editCategory.blade.php ENDPATH**/ ?>