<div class="card-product bg_white radius-0"  data-currency="<?php echo e(config('app.currency')); ?>">
    <div class="card-product-wrapper">
        <a href="<?php echo e(route('product.details', $product->link)); ?>" class="product-img">
            <img class="lazyload img-product" data-src="<?php echo e($product->defaultVariant->first_image); ?>" src="<?php echo e($product->defaultVariant->first_image); ?>" alt="<?php echo e($product->name); ?> - <?php echo e($product->defaultVariant->color); ?>">
            <img class="img-hover ls-is-cached lazyloaded" data-src="<?php echo e($product->defaultVariant->second_image); ?>" src="<?php echo e($product->defaultVariant->second_image); ?>" alt="<?php echo e($product->name); ?> - <?php echo e($product->defaultVariant->color); ?>">

        </a>
        <?php if($product->isInStock($product->defaultVariant->id) == false): ?>
            <span class="alarm"><?php echo e(__('home.out of stock')); ?></span>
        <?php endif; ?>
    </div>

    <div class="card-product-info has-padding">
        <a href="<?php echo e(route('product.details', $product->link)); ?>" class="title link">
            <?php echo e($product->name); ?>

        </a>


        <?php if($product->isOnSale(($product->defaultVariant->id))): ?>
            <div class="sale-price">
                <strong>Now:</strong> <?php echo e(config('app.currency')); ?> <?php echo e($product->getEffectivePrice($product->defaultVariant->id)); ?>

            </div>
            <div class="original-price">
                <strong>Before sale price:</strong>
                <del><?php echo e(config('app.currency')); ?> <?php echo e($product->getOriginalPrice($product->defaultVariant->id)); ?></del>
            </div>
            <div class="save-discount">
                <strong>Save:</strong> <?php echo e(config('app.currency')); ?> <?php echo e($product->getDiscountAmount($product->defaultVariant->id)); ?>

            </div>
        <?php else: ?>
            <span class="original-price"><?php echo e(config('app.currency')); ?> <?php echo e($product->getOriginalPrice($product->defaultVariant->id)); ?></span>
        <?php endif; ?>

        <ul class="list-color-product">

            <?php $__currentLoopData = $product->available_colors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $colorGroup): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

            <li class="list-color-item color-swatch <?php echo e($loop->first ? 'active' : ''); ?>"
                data-currency="<?php echo e(config('app.currency')); ?>"
                data-color="<?php echo e($colorGroup['color']); ?>"
                data-is-on-sale="<?php echo e($product->isOnSale($colorGroup['variant_id'])); ?>"
                data-original-price="<?php echo e($product->getOriginalPrice($colorGroup['variant_id'])); ?>"
                data-effective-price="<?php echo e($product->getEffectivePrice($colorGroup['variant_id'])); ?>"
                data-discount-amount="<?php echo e($product->getDiscountAmount($colorGroup['variant_id'])); ?>"
                data-is-in-stock="<?php echo e($product->isInStock($colorGroup['variant_id']) ? 'true' : 'false'); ?>"
            >
                <span class="tooltip"><?php echo e($colorGroup['color']); ?></span>
                <span class="swatch-value" style="background-color:<?php echo e($colorGroup['color']); ?>"></span>
                <img class="lazyload" data-src="<?php echo e($colorGroup['image']); ?>" src="<?php echo e($colorGroup['image']); ?>" alt="<?php echo e($product->name); ?> - <?php echo e($colorGroup['color']); ?>">
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>
<?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/home-partials/partials/_product-variant.blade.php ENDPATH**/ ?>