<?php $__env->startSection('meta'); ?>
<?php echo $metatags ?>

<?php echo $schema ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<!-- page-title -->
<?php echo $__env->make('website._breadcrumb', ['page_title' => __('home.inspection_request')], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!-- /page-title -->


<!-- form -->
<section class="flat-spacing-21">
    <div class="container">
        <div class="tf-grid-layout gap30 lg-col-2">
            <div class="tf-content-left">

                <figure class="br-lg">
                    <?php if(app()->getLocale() == 'ar'): ?>
                       <img src="<?php echo e(asset('assets/front/images/inspection_request.png')); ?>" alt="commercials request image" width="610" height="500"/>
                    <?php else: ?>
                     <img src="<?php echo e(asset('assets/front/images/inspection_request.png')); ?>" alt="commercials request image" width="610" height="500"/>
                    <?php endif; ?>
                 
                </figure>
            </div>
            <div class="tf-content-right">
                <div class="tf-page-cart-item">
                    
                    <form action="<?php echo e(route('website.saveInspectionRequest')); ?>" method="POST" class="form-checkout">
                        <?php echo csrf_field(); ?>
                        <div  class="box fieldset">
                            <fieldset class="fieldset">
                                <label for="first-name"><?php echo e(__('home.name')); ?></label>
                                <input type="text" id="first-name" placeholder="<?php echo e(__('home.name')); ?>" value="<?php echo e(old('name')); ?>" name='name' required>
                            </fieldset>
                            
                        </div>
    
                        <div class="box grid-2">
                            <fieldset class="box fieldset">
                                <label for="phone"><?php echo e(__('home.Phone Number')); ?></label>
                                <input type="number" id="phone" placeholder="<?php echo e(__('Enter phone number')); ?>" name="phone" value="<?php echo e(old('phone')); ?>" required>
                            </fieldset>
                            <fieldset class="box fieldset">
                                <label for="email"><?php echo e(__('home.Email')); ?></label>
                                <input type="email" id="email" placeholder="<?php echo e(__('Enter email')); ?>" name="email" value="<?php echo e(old('email')); ?>">
                            </fieldset>
                        </div>
    
                        <fieldset class="box fieldset">
                            <label for="country"><?php echo e(__('home.country')); ?></label>
                            <div class="select-custom">
                                <select class="tf-select w-100" id="country" name="country_id" required data-default="">
                                    <option value="null"><?php echo e(__('home.select_country')); ?></option>
                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($country->id); ?>" selected><?php echo e($country->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </fieldset>
    
                        <div class="box grid-2">
                            <fieldset>
                                <label for="governorates"><?php echo e(__('home.governorates')); ?></label>
                                <div class="select-custom">
                                    <select class="tf-select w-100 governorate" id="governorates" name="governorate_id" required data-default="">
                                        <option value="null"><?php echo e(__('home.select_governorate')); ?></option>
                                        <?php $__currentLoopData = $governorates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $governorate): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($governorate->id); ?>"><?php echo e($governorate->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                            </fieldset>
    
                            <fieldset class="box fieldset">
                                <label for="city"><?php echo e(__('home.Town/City')); ?></label>
                                <input type="text" id="city" placeholder="<?php echo e(__('home.Town/City')); ?>" name="city" value="<?php echo e(old('city')); ?>" required>
                            </fieldset>
                        </div>
    
    
    
                        <fieldset class="box fieldset">
                            <label for="address"><?php echo e(__('home.Address')); ?></label>
                            <input type="text" id="address" placeholder="<?php echo e(__('home.Address')); ?>" name="address" value="<?php echo e(old('address')); ?>" required>
                        </fieldset>

                        <fieldset class="box fieldset">
                            <label for="note"><?php echo e(__('home.Order notes (optional)')); ?></label>
                            <textarea name="note" id="note"><?php echo e(old('note')); ?></textarea>
                        </fieldset>
    
                   
                        <div class="box">
                         
                            <button type="submit" class="tf-btn radius-3 btn-fill btn-icon animate-hover-btn justify-content-center"><?php echo e(__('home.send_request')); ?></button>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- /form -->



<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/website/inspection-request.blade.php ENDPATH**/ ?>