<title><?php echo e(trans('home.home_sliders')); ?></title>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <!-- Page Header -->
        <div class="page-header">
            <div>
                <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.home_sliders')); ?></h2>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                    <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.home_sliders')); ?></li>
                </ol>
            </div>
            <div class="btn btn-list">
                <a href="<?php echo e(url('admin/sliders/create')); ?>"><button class="btn ripple btn-primary"><?php echo e(trans('home.add')); ?></button></a>
                <a id="btn_active"><button class="btn ripple btn-dark"><?php echo e(trans('home.publish/unpublish')); ?></button></a>
                <a id="btn_delete" ><button class="btn ripple btn-danger"><?php echo e(trans('home.delete')); ?></button></a>
            </div>
        </div>
        <!-- End Page Header -->
        <?php if(session()->has('success')): ?>
            <div class="alert alert-success">
                <?php echo e(session()->pull('success')); ?>

                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
        <?php endif; ?>
        <!-- Row-->
        <div class="row">
            <div class="col-sm-12 col-xl-12 col-lg-12">

                <div class="card custom-card overflow-hidden">
                    <div class="card-body">
                        <div>
                            <h6 class="card-title mb-1"><?php echo e(trans('home.home_sliders')); ?></h6>
                            <p class="text-muted card-sub-title"><?php echo e(trans('home.table_contain_all_data_shortly_you_can_view_more_details')); ?></p>
                        </div>

                        <div class="table-responsive">
                        <table class="table" id="exportexample">
                            <thead>
                                <tr>
                                    <th><input type="checkbox" id="checkAll"/></th>
                                    <th><?php echo e(trans('home.id')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.title_en')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.title_ar')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.type')); ?></th>
                                    <th class="wd-20p"><?php echo e(trans('home.image')); ?></th>
                                    <th class="wd-15p"><?php echo e(trans('home.status')); ?></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $sliders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $slider): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr id="<?php echo e($slider->id); ?>">
                                        <td> <input type="checkbox" name="checkbox"  class="tableChecked" value="<?php echo e($slider->id); ?>"/></td>
                                        <td><a href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><?php echo e($slider->id); ?></a></td>
                                        <td><a href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><?php echo e($slider->title_en); ?></a></td>
                                        <td><a href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><?php echo e($slider->title_ar); ?></a></td>
                                        <td><a href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><?php echo e($slider->type); ?></a></td>
                                        <td><a href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><img src="<?php echo e($slider->image_path); ?>" width="70"></a></td>
                                        <td><a class="status" href="<?php echo e(route('sliders.edit', $slider->id)); ?>"><?php if($slider->status == 1): ?> <?php echo e(trans('home.yes')); ?> <?php else: ?>  <?php echo e(trans('home.no')); ?> <?php endif; ?></a></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
					</div>
                </div>

                </div>
            </div>
        </div>
        <!-- End Row -->
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/sliders/home-sliders/sliders.blade.php ENDPATH**/ ?>