<?php $__env->startSection('meta'); ?>
<title><?php echo e(trans('home.edit_setting')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
<div class="container-fluid">

    <!-- Page Header -->
    <div class="page-header">
        <div>
            <h2 class="main-content-title tx-24 mg-b-5"><?php echo e(trans('home.edit_setting')); ?></h2>
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(url('/admin')); ?>"><?php echo e(trans('home.admin')); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(trans('home.edit_setting')); ?></li>
            </ol>
        </div>
    </div>
    <!-- End Page Header -->

    <?php if(session()->has('success')): ?>
        <div class="alert alert-success">
            <?php echo e(session()->pull('success')); ?>

            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
    <?php endif; ?>

    <!-- Row-->
    <div class="row">
        <div class="col-sm-12 col-xl-12 col-lg-12">
            <div class="card custom-card overflow-hidden">

                <div class="card-body">

                    <div>
                        <h6 class="card-title mb-1"><?php echo e(trans('home.edit_setting')); ?></h6>
                    </div>
               
                    <form action="<?php echo e(route('settings.update',$lang)); ?>" method="POST" enctype="multipart/form-data">

                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        

                        <div class="row">
                            <div class="form-group col-md-3">
                                <label for="helperText"><?php echo e(trans('home.default_lang')); ?></label>
                                <select class="form-control select2" name="lang" required>
                                    <option value="en" <?php echo e(config('site_lang') == 'en' ? 'selected' : ''); ?>>
                                        <?php echo e(trans('home.english')); ?></option>
                                    <option value="ar" <?php echo e(config('site_lang') == 'ar' ? 'selected' : ''); ?>>
                                        <?php echo e(trans('home.arabic')); ?></option>
                                </select>
                            </div>


                            <div class="form-group col-md-3">
                                <label class=""><?php echo e(trans('home.shipping_free_in')); ?></label>
                                <div class="input-group mb-3">
                                    <input type="text" name="free_amount" id="free_amount" class="form-control" value="<?php echo e(config('setting_free_amount')); ?>" aria-label="Text input with checkbox">
                                </div>
                            </div>

                            <div>
                                <label for="standard"><?php echo e(__('Standard Shipping Fees')); ?></label>
                                <div class="input-group mb-3">
                                    <input type="text" name="standard_shipping_fees" id="standard_shipping_fees" class="form-control" value="<?php echo e(config('setting_standard_shipping_fees')); ?>" aria-label="Text input with checkbox">
                                </div>
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.contact_email')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.contact_email')); ?>" name="contact_email" value="<?php echo e(config('setting_contact_email')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.telphone')); ?></label>
                                <input type="number" min="0" class="form-control" placeholder="<?php echo e(trans('home.telephone')); ?>" name="telephone" value="<?php echo e(config('setting_telephone')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.email')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.email')); ?>" name="email" value="<?php echo e(config('setting_email')); ?>">
                            </div>
                            
                            
                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.mobile')); ?></label>
                                <input type="number" min="0" class="form-control" placeholder="<?php echo e(trans('home.mobile')); ?>" name="mobile" value="<?php echo e(config('setting_mobile')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.fax')); ?></label>
                                <input type="text" min="0" class="form-control" placeholder="<?php echo e(trans('home.fax')); ?>" name="fax" value="<?php echo e(config('setting_fax')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.whatsapp')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.whatsapp')); ?>" name="whatsapp" value="<?php echo e(config('setting_whatsapp')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.snapchat')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.snapchat')); ?>" name="snapchat" value="<?php echo e(config('setting_snapchat')); ?>">
                            </div>
                            <div class="form-group col-md-2">
                                <label class=""><?php echo e(trans('home.tiktok')); ?></label>
                                <input type="text"  class="form-control" placeholder="<?php echo e(trans('home.tiktok')); ?>" name="tiktok" value="<?php echo e(config('setting_tiktok')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="facebook"><?php echo e(trans('home.facebook')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.facebook')); ?>" name="facebook" value="<?php echo e(config('setting_facebook')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="linkedin"><?php echo e(trans('home.linkedin')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.linkedin')); ?>" name="linkedin" value="<?php echo e(config('setting_linkedin')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="instagram"><?php echo e(trans('home.instagram')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.instagram')); ?>" name="instagram" value="<?php echo e(config('setting_instgram')); ?>">
                            </div>

                            <div class="form-group col-md-2">
                                <label for="twitter"><?php echo e(trans('home.twitter')); ?></label>
                                <input type="text" class="form-control" placeholder="<?php echo e(trans('home.twitter')); ?>" name="twitter" value="<?php echo e(config('setting_twitter')); ?>">
                            </div>


                            <div class="form-group col-md-12">
                                <label><?php echo e(trans('home.map_url')); ?></label>
                                <textarea class="form-control" name="map_url" type="text" placeholder="<?php echo e(trans('home.map_url')); ?>"><?php echo e(config('setting_map_url')); ?></textarea>
                            </div>


                            <div class="form-group col-md-12 ">
                                <iframe src="<?php echo e(config('setting_map_url')); ?>" width="100%" height="250" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                            </div>


                            <div class="form-group col-md-12">
                                <label><?php echo e(trans('gtm_script')); ?></label>
                                <textarea class="form-control" name="gtm_script" type="text" placeholder="<?php echo e(trans('gtm_script')); ?>"><?php echo e(config('setting_gtm_script')); ?></textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <label><?php echo e(trans('gtm_noscript')); ?></label>
                                <textarea class="form-control" name="gtm_noscript" type="text" placeholder="<?php echo e(trans('gtm_noscript')); ?>"><?php echo e(config('setting_gtm_noscript')); ?></textarea>
                            </div>

                            <div class="form-group col-md-12">
                                <button type="submit" class="btn btn-success"><i class="icon-note"></i>
                                    <?php echo e(trans('home.save')); ?> </button>
                                <a href="<?php echo e(url('/admin')); ?>"><button type="button" class="btn btn-danger mr-1"><i class="icon-trash"></i> <?php echo e(trans('home.cancel')); ?></button></a>
                            </div>

                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!-- End Row -->
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/webtest3/public_html/naguib-selim/resources/views/admin/settings/setting.blade.php ENDPATH**/ ?>